/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.annotation.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.annotation.client.ApiCallback;
import com.groupdocs.cloud.annotation.client.ApiClient;
import com.groupdocs.cloud.annotation.client.ApiException;
import com.groupdocs.cloud.annotation.client.ApiResponse;
import com.groupdocs.cloud.annotation.client.Configuration;
import com.groupdocs.cloud.annotation.client.Pair;
import com.groupdocs.cloud.annotation.client.ProgressRequestBody;
import com.groupdocs.cloud.annotation.client.ProgressResponseBody;
import com.groupdocs.cloud.annotation.model.AnnotateOptions;
import com.groupdocs.cloud.annotation.model.AnnotationApiLink;
import com.groupdocs.cloud.annotation.model.AnnotationInfo;
import com.groupdocs.cloud.annotation.model.FileInfo;
import com.groupdocs.cloud.annotation.model.RemoveOptions;
import com.groupdocs.cloud.annotation.model.requests.AnnotateDirectRequest;
import com.groupdocs.cloud.annotation.model.requests.AnnotateRequest;
import com.groupdocs.cloud.annotation.model.requests.ExtractRequest;
import com.groupdocs.cloud.annotation.model.requests.RemoveAnnotationsRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AnnotateApi {
    private ApiClient apiClient;

    public AnnotateApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public AnnotateApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call annotateCall(AnnotateRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AnnotateOptions localVarPostBody = request.getoptions();
        String localVarPath = "/annotation/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call annotateValidateBeforeCall(AnnotateRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling annotate(Async)");
        }
        Call call = this.annotateCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AnnotationApiLink annotate(AnnotateRequest request) throws ApiException {
        ApiResponse<AnnotationApiLink> resp = this.annotateWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<AnnotationApiLink> annotateWithHttpInfo(AnnotateRequest request) throws ApiException {
        Call call = this.annotateValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AnnotationApiLink>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call annotateAsync(AnnotateRequest request, final ApiCallback<AnnotationApiLink> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.annotateValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotationApiLink>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call annotateDirectCall(AnnotateDirectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AnnotateOptions localVarPostBody = request.getoptions();
        String localVarPath = "/annotation/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call annotateDirectValidateBeforeCall(AnnotateDirectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling annotateDirect(Async)");
        }
        Call call = this.annotateDirectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File annotateDirect(AnnotateDirectRequest request) throws ApiException {
        ApiResponse<File> resp = this.annotateDirectWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> annotateDirectWithHttpInfo(AnnotateDirectRequest request) throws ApiException {
        Call call = this.annotateDirectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call annotateDirectAsync(AnnotateDirectRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.annotateDirectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call extractCall(ExtractRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FileInfo localVarPostBody = request.getfileInfo();
        String localVarPath = "/annotation/extract";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call extractValidateBeforeCall(ExtractRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getfileInfo() == null) {
            throw new ApiException("Missing the required parameter 'fileInfo' when calling extract(Async)");
        }
        Call call = this.extractCall(request, progressListener, progressRequestListener);
        return call;
    }

    public List<AnnotationInfo> extract(ExtractRequest request) throws ApiException {
        ApiResponse<List<AnnotationInfo>> resp = this.extractWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<List<AnnotationInfo>> extractWithHttpInfo(ExtractRequest request) throws ApiException {
        Call call = this.extractValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<List<AnnotationInfo>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call extractAsync(ExtractRequest request, final ApiCallback<List<AnnotationInfo>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.extractValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<AnnotationInfo>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeAnnotationsCall(RemoveAnnotationsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemoveOptions localVarPostBody = request.getoptions();
        String localVarPath = "/annotation/remove";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeAnnotationsValidateBeforeCall(RemoveAnnotationsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getoptions() == null) {
            throw new ApiException("Missing the required parameter 'options' when calling removeAnnotations(Async)");
        }
        Call call = this.removeAnnotationsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public AnnotationApiLink removeAnnotations(RemoveAnnotationsRequest request) throws ApiException {
        ApiResponse<AnnotationApiLink> resp = this.removeAnnotationsWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<AnnotationApiLink> removeAnnotationsWithHttpInfo(RemoveAnnotationsRequest request) throws ApiException {
        Call call = this.removeAnnotationsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<AnnotationApiLink>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeAnnotationsAsync(RemoveAnnotationsRequest request, final ApiCallback<AnnotationApiLink> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeAnnotationsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AnnotationApiLink>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

