/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.annotation.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.annotation.model.AnnotationInfo;
import com.groupdocs.cloud.annotation.model.FileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines options for annotating documents")
public class AnnotateOptions {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="annotations")
    private List<AnnotationInfo> annotations = null;
    @SerializedName(value="firstPage")
    private Integer firstPage = null;
    @SerializedName(value="lastPage")
    private Integer lastPage = null;
    @SerializedName(value="onlyAnnotatedPages")
    private Boolean onlyAnnotatedPages = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;
    @SerializedName(value="fontsPath")
    private String fontsPath = null;

    public AnnotateOptions fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="Input document description")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public AnnotateOptions annotations(List<AnnotationInfo> annotations) {
        this.annotations = annotations;
        return this;
    }

    public AnnotateOptions addAnnotationsItem(AnnotationInfo annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationInfo>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    @ApiModelProperty(value="List of annotations to add to the document")
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    public AnnotateOptions firstPage(Integer firstPage) {
        this.firstPage = firstPage;
        return this;
    }

    @ApiModelProperty(required=true, value="First page number when saving page range")
    public Integer getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(Integer firstPage) {
        this.firstPage = firstPage;
    }

    public AnnotateOptions lastPage(Integer lastPage) {
        this.lastPage = lastPage;
        return this;
    }

    @ApiModelProperty(required=true, value="Last page number when saving page range")
    public Integer getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(Integer lastPage) {
        this.lastPage = lastPage;
    }

    public AnnotateOptions onlyAnnotatedPages(Boolean onlyAnnotatedPages) {
        this.onlyAnnotatedPages = onlyAnnotatedPages;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether to save only annotated pages")
    public Boolean getOnlyAnnotatedPages() {
        return this.onlyAnnotatedPages;
    }

    public void setOnlyAnnotatedPages(Boolean onlyAnnotatedPages) {
        this.onlyAnnotatedPages = onlyAnnotatedPages;
    }

    public AnnotateOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Path to output document in the cloud storage. Required for Add method. Not required if Annotate (with file result) method used.")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public AnnotateOptions fontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
        return this;
    }

    @ApiModelProperty(value="The path to directory containing custom fonts in storage")
    public String getFontsPath() {
        return this.fontsPath;
    }

    public void setFontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotateOptions annotateOptions = (AnnotateOptions)o;
        return Objects.equals(this.fileInfo, annotateOptions.fileInfo) && Objects.equals(this.annotations, annotateOptions.annotations) && Objects.equals(this.firstPage, annotateOptions.firstPage) && Objects.equals(this.lastPage, annotateOptions.lastPage) && Objects.equals(this.onlyAnnotatedPages, annotateOptions.onlyAnnotatedPages) && Objects.equals(this.outputPath, annotateOptions.outputPath) && Objects.equals(this.fontsPath, annotateOptions.fontsPath);
    }

    public int hashCode() {
        return Objects.hash(this.fileInfo, this.annotations, this.firstPage, this.lastPage, this.onlyAnnotatedPages, this.outputPath, this.fontsPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnotateOptions {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    firstPage: ").append(this.toIndentedString(this.firstPage)).append("\n");
        sb.append("    lastPage: ").append(this.toIndentedString(this.lastPage)).append("\n");
        sb.append("    onlyAnnotatedPages: ").append(this.toIndentedString(this.onlyAnnotatedPages)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("    fontsPath: ").append(this.toIndentedString(this.fontsPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

