/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.annotation.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.annotation.model.AnnotationReplyInfo;
import com.groupdocs.cloud.annotation.model.Point;
import com.groupdocs.cloud.annotation.model.Rectangle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Describes annotation properties")
public class AnnotationInfo {
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="textToReplace")
    private String textToReplace = null;
    @SerializedName(value="horizontalAlignment")
    private HorizontalAlignmentEnum horizontalAlignment = null;
    @SerializedName(value="verticalAlignment")
    private VerticalAlignmentEnum verticalAlignment = null;
    @SerializedName(value="creatorId")
    private Integer creatorId = null;
    @SerializedName(value="creatorName")
    private String creatorName = null;
    @SerializedName(value="creatorEmail")
    private String creatorEmail = null;
    @SerializedName(value="box")
    private Rectangle box = null;
    @SerializedName(value="points")
    private List<Point> points = null;
    @SerializedName(value="pageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="annotationPosition")
    private Point annotationPosition = null;
    @SerializedName(value="svgPath")
    private String svgPath = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="replies")
    private List<AnnotationReplyInfo> replies = null;
    @SerializedName(value="createdOn")
    private OffsetDateTime createdOn = null;
    @SerializedName(value="fontColor")
    private Integer fontColor = null;
    @SerializedName(value="penColor")
    private Integer penColor = null;
    @SerializedName(value="penWidth")
    private Integer penWidth = null;
    @SerializedName(value="penStyle")
    private PenStyleEnum penStyle = null;
    @SerializedName(value="backgroundColor")
    private Integer backgroundColor = null;
    @SerializedName(value="squigglyColor")
    private Integer squigglyColor = null;
    @SerializedName(value="fontFamily")
    private String fontFamily = null;
    @SerializedName(value="fontSize")
    private Double fontSize = null;
    @SerializedName(value="opacity")
    private Double opacity = null;
    @SerializedName(value="angle")
    private Double angle = null;
    @SerializedName(value="zindex")
    private Integer zindex = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="imagePath")
    private String imagePath = null;
    @SerializedName(value="autoScale")
    private Boolean autoScale = null;

    public AnnotationInfo id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the unique identifier")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AnnotationInfo text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public AnnotationInfo textToReplace(String textToReplace) {
        this.textToReplace = textToReplace;
        return this;
    }

    @ApiModelProperty(value="GGets or sets text to be replaced")
    public String getTextToReplace() {
        return this.textToReplace;
    }

    public void setTextToReplace(String textToReplace) {
        this.textToReplace = textToReplace;
    }

    public AnnotationInfo horizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets text horizontal alignment")
    public HorizontalAlignmentEnum getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignmentEnum horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public AnnotationInfo verticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets text vertical alignment")
    public VerticalAlignmentEnum getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public AnnotationInfo creatorId(Integer creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the creator unique identifier")
    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public AnnotationInfo creatorName(String creatorName) {
        this.creatorName = creatorName;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the name of the creator")
    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public AnnotationInfo creatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the creator's email")
    public String getCreatorEmail() {
        return this.creatorEmail;
    }

    public void setCreatorEmail(String creatorEmail) {
        this.creatorEmail = creatorEmail;
    }

    public AnnotationInfo box(Rectangle box) {
        this.box = box;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the box where annotation will be placed")
    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle box) {
        this.box = box;
    }

    public AnnotationInfo points(List<Point> points) {
        this.points = points;
        return this;
    }

    public AnnotationInfo addPointsItem(Point pointsItem) {
        if (this.points == null) {
            this.points = new ArrayList<Point>();
        }
        this.points.add(pointsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets collection of points that describe rectangles with text")
    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public AnnotationInfo pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the number of page where annotation will be placed")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public AnnotationInfo annotationPosition(Point annotationPosition) {
        this.annotationPosition = annotationPosition;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation position")
    public Point getAnnotationPosition() {
        return this.annotationPosition;
    }

    public void setAnnotationPosition(Point annotationPosition) {
        this.annotationPosition = annotationPosition;
    }

    public AnnotationInfo svgPath(String svgPath) {
        this.svgPath = svgPath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation SVG path")
    public String getSvgPath() {
        return this.svgPath;
    }

    public void setSvgPath(String svgPath) {
        this.svgPath = svgPath;
    }

    public AnnotationInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the annotation type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AnnotationInfo replies(List<AnnotationReplyInfo> replies) {
        this.replies = replies;
        return this;
    }

    public AnnotationInfo addRepliesItem(AnnotationReplyInfo repliesItem) {
        if (this.replies == null) {
            this.replies = new ArrayList<AnnotationReplyInfo>();
        }
        this.replies.add(repliesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the array of annotation replies")
    public List<AnnotationReplyInfo> getReplies() {
        return this.replies;
    }

    public void setReplies(List<AnnotationReplyInfo> replies) {
        this.replies = replies;
    }

    public AnnotationInfo createdOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the annotation created on date")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
    }

    public AnnotationInfo fontColor(Integer fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's font color")
    public Integer getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Integer fontColor) {
        this.fontColor = fontColor;
    }

    public AnnotationInfo penColor(Integer penColor) {
        this.penColor = penColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's pen color")
    public Integer getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Integer penColor) {
        this.penColor = penColor;
    }

    public AnnotationInfo penWidth(Integer penWidth) {
        this.penWidth = penWidth;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's pen width")
    public Integer getPenWidth() {
        return this.penWidth;
    }

    public void setPenWidth(Integer penWidth) {
        this.penWidth = penWidth;
    }

    public AnnotationInfo penStyle(PenStyleEnum penStyle) {
        this.penStyle = penStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's pen style")
    public PenStyleEnum getPenStyle() {
        return this.penStyle;
    }

    public void setPenStyle(PenStyleEnum penStyle) {
        this.penStyle = penStyle;
    }

    public AnnotationInfo backgroundColor(Integer backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's background color ")
    public Integer getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Integer backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public AnnotationInfo squigglyColor(Integer squigglyColor) {
        this.squigglyColor = squigglyColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets annotation color")
    public Integer getSquigglyColor() {
        return this.squigglyColor;
    }

    public void setSquigglyColor(Integer squigglyColor) {
        this.squigglyColor = squigglyColor;
    }

    public AnnotationInfo fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's font family")
    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public AnnotationInfo fontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's font size ")
    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public AnnotationInfo opacity(Double opacity) {
        this.opacity = opacity;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the annotation's opacity")
    public Double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Double opacity) {
        this.opacity = opacity;
    }

    public AnnotationInfo angle(Double angle) {
        this.angle = angle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the watermark annotation's rotation angle")
    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }

    public AnnotationInfo zindex(Integer zindex) {
        this.zindex = zindex;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets z-index. Default value is 0 The z-index property specifies the stack order of an element.")
    public Integer getZindex() {
        return this.zindex;
    }

    public void setZindex(Integer zindex) {
        this.zindex = zindex;
    }

    public AnnotationInfo url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Gets or sets annotation link url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AnnotationInfo imagePath(String imagePath) {
        this.imagePath = imagePath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets image file path in cloud storage, for Image annotations")
    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public AnnotationInfo autoScale(Boolean autoScale) {
        this.autoScale = autoScale;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets auto scale for watermark annotation")
    public Boolean getAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(Boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInfo annotationInfo = (AnnotationInfo)o;
        return Objects.equals(this.id, annotationInfo.id) && Objects.equals(this.text, annotationInfo.text) && Objects.equals(this.textToReplace, annotationInfo.textToReplace) && Objects.equals((Object)this.horizontalAlignment, (Object)annotationInfo.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)annotationInfo.verticalAlignment) && Objects.equals(this.creatorId, annotationInfo.creatorId) && Objects.equals(this.creatorName, annotationInfo.creatorName) && Objects.equals(this.creatorEmail, annotationInfo.creatorEmail) && Objects.equals(this.box, annotationInfo.box) && Objects.equals(this.points, annotationInfo.points) && Objects.equals(this.pageNumber, annotationInfo.pageNumber) && Objects.equals(this.annotationPosition, annotationInfo.annotationPosition) && Objects.equals(this.svgPath, annotationInfo.svgPath) && Objects.equals((Object)this.type, (Object)annotationInfo.type) && Objects.equals(this.replies, annotationInfo.replies) && Objects.equals(this.createdOn, annotationInfo.createdOn) && Objects.equals(this.fontColor, annotationInfo.fontColor) && Objects.equals(this.penColor, annotationInfo.penColor) && Objects.equals(this.penWidth, annotationInfo.penWidth) && Objects.equals((Object)this.penStyle, (Object)annotationInfo.penStyle) && Objects.equals(this.backgroundColor, annotationInfo.backgroundColor) && Objects.equals(this.squigglyColor, annotationInfo.squigglyColor) && Objects.equals(this.fontFamily, annotationInfo.fontFamily) && Objects.equals(this.fontSize, annotationInfo.fontSize) && Objects.equals(this.opacity, annotationInfo.opacity) && Objects.equals(this.angle, annotationInfo.angle) && Objects.equals(this.zindex, annotationInfo.zindex) && Objects.equals(this.url, annotationInfo.url) && Objects.equals(this.imagePath, annotationInfo.imagePath) && Objects.equals(this.autoScale, annotationInfo.autoScale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.text, this.textToReplace, this.horizontalAlignment, this.verticalAlignment, this.creatorId, this.creatorName, this.creatorEmail, this.box, this.points, this.pageNumber, this.annotationPosition, this.svgPath, this.type, this.replies, this.createdOn, this.fontColor, this.penColor, this.penWidth, this.penStyle, this.backgroundColor, this.squigglyColor, this.fontFamily, this.fontSize, this.opacity, this.angle, this.zindex, this.url, this.imagePath, this.autoScale});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnotationInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    textToReplace: ").append(this.toIndentedString(this.textToReplace)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        sb.append("    creatorName: ").append(this.toIndentedString(this.creatorName)).append("\n");
        sb.append("    creatorEmail: ").append(this.toIndentedString(this.creatorEmail)).append("\n");
        sb.append("    box: ").append(this.toIndentedString(this.box)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    annotationPosition: ").append(this.toIndentedString(this.annotationPosition)).append("\n");
        sb.append("    svgPath: ").append(this.toIndentedString(this.svgPath)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    replies: ").append(this.toIndentedString(this.replies)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    fontColor: ").append(this.toIndentedString(this.fontColor)).append("\n");
        sb.append("    penColor: ").append(this.toIndentedString(this.penColor)).append("\n");
        sb.append("    penWidth: ").append(this.toIndentedString(this.penWidth)).append("\n");
        sb.append("    penStyle: ").append(this.toIndentedString((Object)this.penStyle)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    squigglyColor: ").append(this.toIndentedString(this.squigglyColor)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    zindex: ").append(this.toIndentedString(this.zindex)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    imagePath: ").append(this.toIndentedString(this.imagePath)).append("\n");
        sb.append("    autoScale: ").append(this.toIndentedString(this.autoScale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PenStyleEnum {
        SOLID("Solid"),
        DASH("Dash"),
        DASHDOT("DashDot"),
        DOT("Dot"),
        LONGDASH("LongDash"),
        DASHDOTDOT("DashDotDot");

        private String value;

        private PenStyleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PenStyleEnum fromValue(String text) {
            for (PenStyleEnum b : PenStyleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PenStyleEnum> {
            public void write(JsonWriter jsonWriter, PenStyleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PenStyleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PenStyleEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NONE("None"),
        AREA("Area"),
        ARROW("Arrow"),
        DISTANCE("Distance"),
        ELLIPSE("Ellipse"),
        LINK("Link"),
        POINT("Point"),
        POLYLINE("Polyline"),
        RESOURCESREDACTION("ResourcesRedaction"),
        TEXTFIELD("TextField"),
        TEXTHIGHLIGHT("TextHighlight"),
        TEXTREDACTION("TextRedaction"),
        TEXTREPLACEMENT("TextReplacement"),
        TEXTSTRIKEOUT("TextStrikeout"),
        TEXTUNDERLINE("TextUnderline"),
        WATERMARK("Watermark"),
        IMAGE("Image"),
        TEXTSQUIGGLY("TextSquiggly");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalAlignmentEnum {
        NONE("None"),
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private VerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalAlignmentEnum fromValue(String text) {
            for (VerticalAlignmentEnum b : VerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, VerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HorizontalAlignmentEnum {
        NONE("None"),
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private HorizontalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HorizontalAlignmentEnum fromValue(String text) {
            for (HorizontalAlignmentEnum b : HorizontalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HorizontalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, HorizontalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HorizontalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HorizontalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

