/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.annotation.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.annotation.model.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Describes document basic info")
public class DocumentInfo {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="extension")
    private String extension = null;
    @SerializedName(value="fileFormat")
    private String fileFormat = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="dateModified")
    private OffsetDateTime dateModified = null;
    @SerializedName(value="pages")
    private List<PageInfo> pages = null;

    public DocumentInfo name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the document name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocumentInfo path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the document path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DocumentInfo extension(String extension) {
        this.extension = extension;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the document extension")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public DocumentInfo fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the file format")
    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public DocumentInfo size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the document size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public DocumentInfo dateModified(OffsetDateTime dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the document date modified")
    public OffsetDateTime getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(OffsetDateTime dateModified) {
        this.dateModified = dateModified;
    }

    public DocumentInfo pages(List<PageInfo> pages) {
        this.pages = pages;
        return this;
    }

    public DocumentInfo addPagesItem(PageInfo pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<PageInfo>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the pages")
    public List<PageInfo> getPages() {
        return this.pages;
    }

    public void setPages(List<PageInfo> pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentInfo documentInfo = (DocumentInfo)o;
        return Objects.equals(this.name, documentInfo.name) && Objects.equals(this.path, documentInfo.path) && Objects.equals(this.extension, documentInfo.extension) && Objects.equals(this.fileFormat, documentInfo.fileFormat) && Objects.equals(this.size, documentInfo.size) && Objects.equals(this.dateModified, documentInfo.dateModified) && Objects.equals(this.pages, documentInfo.pages);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path, this.extension, this.fileFormat, this.size, this.dateModified, this.pages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    fileFormat: ").append(this.toIndentedString(this.fileFormat)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

