/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.annotation.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.annotation.model.FileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents options for GetPages API method")
public class PreviewOptions {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="format")
    private FormatEnum format = null;
    @SerializedName(value="pageNumbers")
    private List<Integer> pageNumbers = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="resolution")
    private Integer resolution = null;
    @SerializedName(value="renderComments")
    private Boolean renderComments = null;
    @SerializedName(value="renderAnnotations")
    private Boolean renderAnnotations = null;
    @SerializedName(value="fontsPath")
    private String fontsPath = null;

    public PreviewOptions fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="Input document description")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public PreviewOptions format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview format. Supported values are: PNG, JPEG or BMP. Default value is PNG.")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public PreviewOptions pageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
        return this;
    }

    public PreviewOptions addPageNumbersItem(Integer pageNumbersItem) {
        if (this.pageNumbers == null) {
            this.pageNumbers = new ArrayList<Integer>();
        }
        this.pageNumbers.add(pageNumbersItem);
        return this;
    }

    @ApiModelProperty(value="Page numbers to preview. All pages proceeded if not specified.")
    public List<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    public void setPageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    public PreviewOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview image width. Not required. Default width used if not specified or 0.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PreviewOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview image height. Not required. Default width used if not specified or 0.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PreviewOptions resolution(Integer resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets the resolution for generated images, in dots per inch. The default value is 96.")
    public Integer getResolution() {
        return this.resolution;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public PreviewOptions renderComments(Boolean renderComments) {
        this.renderComments = renderComments;
        return this;
    }

    @ApiModelProperty(required=true, value="Render document comments. Default value is 'false'.")
    public Boolean getRenderComments() {
        return this.renderComments;
    }

    public void setRenderComments(Boolean renderComments) {
        this.renderComments = renderComments;
    }

    public PreviewOptions renderAnnotations(Boolean renderAnnotations) {
        this.renderAnnotations = renderAnnotations;
        return this;
    }

    @ApiModelProperty(required=true, value="The property that controls whether annotations will be generated on the preview. Default State - true.")
    public Boolean getRenderAnnotations() {
        return this.renderAnnotations;
    }

    public void setRenderAnnotations(Boolean renderAnnotations) {
        this.renderAnnotations = renderAnnotations;
    }

    public PreviewOptions fontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
        return this;
    }

    @ApiModelProperty(value="The path to directory containing custom fonts in storage")
    public String getFontsPath() {
        return this.fontsPath;
    }

    public void setFontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewOptions previewOptions = (PreviewOptions)o;
        return Objects.equals(this.fileInfo, previewOptions.fileInfo) && Objects.equals((Object)this.format, (Object)previewOptions.format) && Objects.equals(this.pageNumbers, previewOptions.pageNumbers) && Objects.equals(this.width, previewOptions.width) && Objects.equals(this.height, previewOptions.height) && Objects.equals(this.resolution, previewOptions.resolution) && Objects.equals(this.renderComments, previewOptions.renderComments) && Objects.equals(this.renderAnnotations, previewOptions.renderAnnotations) && Objects.equals(this.fontsPath, previewOptions.fontsPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileInfo, this.format, this.pageNumbers, this.width, this.height, this.resolution, this.renderComments, this.renderAnnotations, this.fontsPath});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreviewOptions {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    pageNumbers: ").append(this.toIndentedString(this.pageNumbers)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    renderComments: ").append(this.toIndentedString(this.renderComments)).append("\n");
        sb.append("    renderAnnotations: ").append(this.toIndentedString(this.renderAnnotations)).append("\n");
        sb.append("    fontsPath: ").append(this.toIndentedString(this.fontsPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        PNG("PNG"),
        JPEG("JPEG"),
        BMP("BMP");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String text) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

