/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.assembly.cloud.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.assembly.cloud.ApiCallback;
import com.groupdocs.assembly.cloud.ApiClient;
import com.groupdocs.assembly.cloud.ApiException;
import com.groupdocs.assembly.cloud.ApiResponse;
import com.groupdocs.assembly.cloud.Configuration;
import com.groupdocs.assembly.cloud.Pair;
import com.groupdocs.assembly.cloud.ProgressRequestBody;
import com.groupdocs.assembly.cloud.ProgressResponseBody;
import com.groupdocs.assembly.cloud.model.AssembleOptions;
import com.groupdocs.assembly.cloud.model.FileFormatsResponse;
import com.groupdocs.assembly.cloud.model.FilesList;
import com.groupdocs.assembly.cloud.model.FilesUploadResult;
import com.groupdocs.assembly.cloud.model.requests.AssembleDocumentRequest;
import com.groupdocs.assembly.cloud.model.requests.CopyFileRequest;
import com.groupdocs.assembly.cloud.model.requests.CopyFolderRequest;
import com.groupdocs.assembly.cloud.model.requests.CreateFolderRequest;
import com.groupdocs.assembly.cloud.model.requests.DeleteFileRequest;
import com.groupdocs.assembly.cloud.model.requests.DeleteFolderRequest;
import com.groupdocs.assembly.cloud.model.requests.DownloadFileRequest;
import com.groupdocs.assembly.cloud.model.requests.GetFilesListRequest;
import com.groupdocs.assembly.cloud.model.requests.GetSupportedFileFormatsRequest;
import com.groupdocs.assembly.cloud.model.requests.MoveFileRequest;
import com.groupdocs.assembly.cloud.model.requests.MoveFolderRequest;
import com.groupdocs.assembly.cloud.model.requests.UploadFileRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class AssemblyApi {
    private Integer NotAuth = 401;
    private Integer BadRequest = 400;
    private ApiClient apiClient;

    public AssemblyApi(String appSid, String appKey, String baseUrl) {
        this(new ApiClient(appSid, appKey, baseUrl));
    }

    public AssemblyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssemblyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call assembleDocumentCall(AssembleDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AssembleOptions localVarPostBody = request.getAssembleOptions();
        String localVarPath = "/assembly/assemble";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call assembleDocumentValidateBeforeCall(AssembleDocumentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getAssembleOptions() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'AssembleOptions' when calling assembleDocument");
        }
        Call call = this.assembleDocumentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File assembleDocument(AssembleDocumentRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.assembleDocumentWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.assembleDocumentWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> assembleDocumentWithHttpInfo(AssembleDocumentRequest request) throws ApiException {
        Call call = this.assembleDocumentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call assembleDocumentAsync(AssembleDocumentRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.assembleDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call copyFileCall(CopyFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/file/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getSrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getDestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getSrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getDestStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getVersionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFileValidateBeforeCall(CopyFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getDestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'DestPath' when calling copyFile");
        }
        if (request.getSrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'SrcPath' when calling copyFile");
        }
        Call call = this.copyFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void copyFile(CopyFileRequest request) throws ApiException {
        try {
            this.copyFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.copyFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> copyFileWithHttpInfo(CopyFileRequest request) throws ApiException {
        Call call = this.copyFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFileAsync(CopyFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call copyFolderCall(CopyFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/folder/copy/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getSrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getDestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getSrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getDestStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFolderValidateBeforeCall(CopyFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getDestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'DestPath' when calling copyFolder");
        }
        if (request.getSrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'SrcPath' when calling copyFolder");
        }
        Call call = this.copyFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void copyFolder(CopyFolderRequest request) throws ApiException {
        try {
            this.copyFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.copyFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> copyFolderWithHttpInfo(CopyFolderRequest request) throws ApiException {
        Call call = this.copyFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call copyFolderAsync(CopyFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call createFolderCall(CreateFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createFolderValidateBeforeCall(CreateFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling createFolder");
        }
        Call call = this.createFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void createFolder(CreateFolderRequest request) throws ApiException {
        try {
            this.createFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.createFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> createFolderWithHttpInfo(CreateFolderRequest request) throws ApiException {
        Call call = this.createFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call createFolderAsync(CreateFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteFileCall(DeleteFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getVersionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFileValidateBeforeCall(DeleteFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling deleteFile");
        }
        Call call = this.deleteFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFile(DeleteFileRequest request) throws ApiException {
        try {
            this.deleteFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.deleteFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> deleteFileWithHttpInfo(DeleteFileRequest request) throws ApiException {
        Call call = this.deleteFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFileAsync(DeleteFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call deleteFolderCall(DeleteFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "recursive", request.getRecursive());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFolderValidateBeforeCall(DeleteFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling deleteFolder");
        }
        Call call = this.deleteFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFolder(DeleteFolderRequest request) throws ApiException {
        try {
            this.deleteFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.deleteFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> deleteFolderWithHttpInfo(DeleteFolderRequest request) throws ApiException {
        Call call = this.deleteFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFolderAsync(DeleteFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call downloadFileCall(DownloadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getVersionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadFileValidateBeforeCall(DownloadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling downloadFile");
        }
        Call call = this.downloadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File downloadFile(DownloadFileRequest request) throws ApiException {
        try {
            ApiResponse<File> resp = this.downloadFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<File> resp = this.downloadFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<File> downloadFileWithHttpInfo(DownloadFileRequest request) throws ApiException {
        Call call = this.downloadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadFileAsync(DownloadFileRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getFilesListCall(GetFilesListRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/folder/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFilesListValidateBeforeCall(GetFilesListRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling getFilesList");
        }
        Call call = this.getFilesListCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FilesList getFilesList(GetFilesListRequest request) throws ApiException {
        try {
            ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FilesList> resp = this.getFilesListWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FilesList> getFilesListWithHttpInfo(GetFilesListRequest request) throws ApiException {
        Call call = this.getFilesListValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFilesListAsync(GetFilesListRequest request, final ApiCallback<FilesList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFilesListValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getSupportedFileFormatsCall(GetSupportedFileFormatsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/formats";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSupportedFileFormatsValidateBeforeCall(GetSupportedFileFormatsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSupportedFileFormatsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FileFormatsResponse getSupportedFileFormats(GetSupportedFileFormatsRequest request) throws ApiException {
        try {
            ApiResponse<FileFormatsResponse> resp = this.getSupportedFileFormatsWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FileFormatsResponse> resp = this.getSupportedFileFormatsWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FileFormatsResponse> getSupportedFileFormatsWithHttpInfo(GetSupportedFileFormatsRequest request) throws ApiException {
        Call call = this.getSupportedFileFormatsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FileFormatsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSupportedFileFormatsAsync(GetSupportedFileFormatsRequest request, final ApiCallback<FileFormatsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSupportedFileFormatsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileFormatsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call moveFileCall(MoveFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/file/move/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getSrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getDestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getSrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getDestStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "versionId", request.getVersionId());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveFileValidateBeforeCall(MoveFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getDestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'DestPath' when calling moveFile");
        }
        if (request.getSrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'SrcPath' when calling moveFile");
        }
        Call call = this.moveFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void moveFile(MoveFileRequest request) throws ApiException {
        try {
            this.moveFileWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.moveFileWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> moveFileWithHttpInfo(MoveFileRequest request) throws ApiException {
        Call call = this.moveFileValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call moveFileAsync(MoveFileRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveFileValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call moveFolderCall(MoveFolderRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/folder/move/{srcPath}".replaceAll("\\{srcPath\\}", this.apiClient.escapeString(request.getSrcPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destPath", request.getDestPath());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "srcStorageName", request.getSrcStorageName());
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "destStorageName", request.getDestStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveFolderValidateBeforeCall(MoveFolderRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getDestPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'DestPath' when calling moveFolder");
        }
        if (request.getSrcPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'SrcPath' when calling moveFolder");
        }
        Call call = this.moveFolderCall(request, progressListener, progressRequestListener);
        return call;
    }

    public void moveFolder(MoveFolderRequest request) throws ApiException {
        try {
            this.moveFolderWithHttpInfo(request);
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                this.moveFolderWithHttpInfo(request);
            }
            throw ex;
        }
    }

    private ApiResponse<Void> moveFolderWithHttpInfo(MoveFolderRequest request) throws ApiException {
        Call call = this.moveFolderValidateBeforeCall(request, null, null);
        return this.apiClient.execute(call);
    }

    public Call moveFolderAsync(MoveFolderRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveFolderValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    private Call uploadFileCall(UploadFileRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/assembly/storage/file/{path}".replaceAll("\\{path\\}", this.apiClient.escapeString(request.getPath().toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        localVarPath = this.addParameterToQuery(localVarQueryParams, localVarPath, "storageName", request.getStorageName());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        if (request.getFileContent() != null) {
            localVarFormParams.put("FileContent", request.getFileContent());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadFileValidateBeforeCall(UploadFileRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getFileContent() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'FileContent' when calling uploadFile");
        }
        if (request.getPath() == null) {
            throw new ApiException(this.BadRequest, "Missing the required parameter 'Path' when calling uploadFile");
        }
        Call call = this.uploadFileCall(request, progressListener, progressRequestListener);
        return call;
    }

    public FilesUploadResult uploadFile(UploadFileRequest request) throws ApiException {
        try {
            ApiResponse<FilesUploadResult> resp = this.uploadFileWithHttpInfo(request);
            return resp.getData();
        }
        catch (ApiException ex) {
            if (ex.getCode() == this.NotAuth.intValue()) {
                this.apiClient.requestToken();
                ApiResponse<FilesUploadResult> resp = this.uploadFileWithHttpInfo(request);
                return resp.getData();
            }
            throw ex;
        }
    }

    private ApiResponse<FilesUploadResult> uploadFileWithHttpInfo(UploadFileRequest request) throws ApiException {
        Call call = this.uploadFileValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadFileAsync(UploadFileRequest request, final ApiCallback<FilesUploadResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadFileValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FilesUploadResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private String addParameterToQuery(List<Pair> queryParams, String path, String paramName, Object paramValue) {
        if (path.contains("{" + paramName + "}")) {
            if (paramValue == null || paramValue.equals("")) {
                return path.replace("{" + paramName + "}", "");
            }
            return path.replace("{" + paramName + "}", paramValue.toString());
        }
        queryParams.addAll(this.apiClient.parameterToPair(paramName, paramValue));
        return path;
    }
}

