/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.assembly.cloud.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.assembly.cloud.model.TemplateFileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Assemble options data which is using for specifying assemble options, like template name, save format, report data and etc.")
public class AssembleOptions {
    @SerializedName(value="TemplateFileInfo")
    private TemplateFileInfo templateFileInfo = null;
    @SerializedName(value="SaveFormat")
    private String saveFormat = null;
    @SerializedName(value="ReportData")
    private String reportData = null;
    @SerializedName(value="OutputPath")
    private String outputPath = null;

    public AssembleOptions templateFileInfo(TemplateFileInfo templateFileInfo) {
        this.templateFileInfo = templateFileInfo;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the template name which is located on storage.")
    public TemplateFileInfo getTemplateFileInfo() {
        return this.templateFileInfo;
    }

    public void setTemplateFileInfo(TemplateFileInfo templateFileInfo) {
        this.templateFileInfo = templateFileInfo;
    }

    public AssembleOptions saveFormat(String saveFormat) {
        this.saveFormat = saveFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a save format for assembled document.")
    public String getSaveFormat() {
        return this.saveFormat;
    }

    public void setSaveFormat(String saveFormat) {
        this.saveFormat = saveFormat;
    }

    public AssembleOptions reportData(String reportData) {
        this.reportData = reportData;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a data for report.")
    public String getReportData() {
        return this.reportData;
    }

    public void setReportData(String reportData) {
        this.reportData = reportData;
    }

    public AssembleOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets result path of a built document.")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssembleOptions assembleOptions = (AssembleOptions)o;
        return Objects.equals(this.templateFileInfo, assembleOptions.templateFileInfo) && Objects.equals(this.saveFormat, assembleOptions.saveFormat) && Objects.equals(this.reportData, assembleOptions.reportData) && Objects.equals(this.outputPath, assembleOptions.outputPath);
    }

    public int hashCode() {
        return Objects.hash(this.templateFileInfo, this.saveFormat, this.reportData, this.outputPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssembleOptions {\n");
        sb.append("    templateFileInfo: ").append(this.toIndentedString(this.templateFileInfo)).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.saveFormat)).append("\n");
        sb.append("    reportData: ").append(this.toIndentedString(this.reportData)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

