/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.comparison.client.ApiCallback;
import com.groupdocs.cloud.comparison.client.ApiClient;
import com.groupdocs.cloud.comparison.client.ApiException;
import com.groupdocs.cloud.comparison.client.ApiResponse;
import com.groupdocs.cloud.comparison.client.Configuration;
import com.groupdocs.cloud.comparison.client.Pair;
import com.groupdocs.cloud.comparison.client.ProgressRequestBody;
import com.groupdocs.cloud.comparison.client.ProgressResponseBody;
import com.groupdocs.cloud.comparison.model.ApplyRevisionsOptions;
import com.groupdocs.cloud.comparison.model.FileInfo;
import com.groupdocs.cloud.comparison.model.Link;
import com.groupdocs.cloud.comparison.model.RevisionInfo;
import com.groupdocs.cloud.comparison.model.requests.ApplyRevisionsRequest;
import com.groupdocs.cloud.comparison.model.requests.GetRevisionsRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public ReviewApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call applyRevisionsCall(ApplyRevisionsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApplyRevisionsOptions localVarPostBody = request.getrevisionOptions();
        String localVarPath = "/comparison/revisions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call applyRevisionsValidateBeforeCall(ApplyRevisionsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getrevisionOptions() == null) {
            throw new ApiException("Missing the required parameter 'revisionOptions' when calling applyRevisions(Async)");
        }
        Call call = this.applyRevisionsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public Link applyRevisions(ApplyRevisionsRequest request) throws ApiException {
        ApiResponse<Link> resp = this.applyRevisionsWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<Link> applyRevisionsWithHttpInfo(ApplyRevisionsRequest request) throws ApiException {
        Call call = this.applyRevisionsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call applyRevisionsAsync(ApplyRevisionsRequest request, final ApiCallback<Link> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.applyRevisionsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Link>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getRevisionsCall(GetRevisionsRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FileInfo localVarPostBody = request.getfileInfo();
        String localVarPath = "/comparison/revisions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRevisionsValidateBeforeCall(GetRevisionsRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getfileInfo() == null) {
            throw new ApiException("Missing the required parameter 'fileInfo' when calling getRevisions(Async)");
        }
        Call call = this.getRevisionsCall(request, progressListener, progressRequestListener);
        return call;
    }

    public List<RevisionInfo> getRevisions(GetRevisionsRequest request) throws ApiException {
        ApiResponse<List<RevisionInfo>> resp = this.getRevisionsWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<List<RevisionInfo>> getRevisionsWithHttpInfo(GetRevisionsRequest request) throws ApiException {
        Call call = this.getRevisionsValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<List<RevisionInfo>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRevisionsAsync(GetRevisionsRequest request, final ApiCallback<List<RevisionInfo>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRevisionsValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<RevisionInfo>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

