/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.comparison.model.FileInfo;
import com.groupdocs.cloud.comparison.model.RevisionInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options for apply revisions method")
public class ApplyRevisionsOptions {
    @SerializedName(value="sourceFile")
    private FileInfo sourceFile = null;
    @SerializedName(value="revisions")
    private List<RevisionInfo> revisions = null;
    @SerializedName(value="acceptAll")
    private Boolean acceptAll = null;
    @SerializedName(value="rejectAll")
    private Boolean rejectAll = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;

    public ApplyRevisionsOptions sourceFile(FileInfo sourceFile) {
        this.sourceFile = sourceFile;
        return this;
    }

    @ApiModelProperty(value="Information about source file")
    public FileInfo getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(FileInfo sourceFile) {
        this.sourceFile = sourceFile;
    }

    public ApplyRevisionsOptions revisions(List<RevisionInfo> revisions) {
        this.revisions = revisions;
        return this;
    }

    public ApplyRevisionsOptions addRevisionsItem(RevisionInfo revisionsItem) {
        if (this.revisions == null) {
            this.revisions = new ArrayList<RevisionInfo>();
        }
        this.revisions.add(revisionsItem);
        return this;
    }

    @ApiModelProperty(value="Revisions to apply or reject.")
    public List<RevisionInfo> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(List<RevisionInfo> revisions) {
        this.revisions = revisions;
    }

    public ApplyRevisionsOptions acceptAll(Boolean acceptAll) {
        this.acceptAll = acceptAll;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether to apply all revisions in the document")
    public Boolean getAcceptAll() {
        return this.acceptAll;
    }

    public void setAcceptAll(Boolean acceptAll) {
        this.acceptAll = acceptAll;
    }

    public ApplyRevisionsOptions rejectAll(Boolean rejectAll) {
        this.rejectAll = rejectAll;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether to reject all revisions in the document")
    public Boolean getRejectAll() {
        return this.rejectAll;
    }

    public void setRejectAll(Boolean rejectAll) {
        this.rejectAll = rejectAll;
    }

    public ApplyRevisionsOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Path to the resultant document (if not specified the document will not be saved)")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplyRevisionsOptions applyRevisionsOptions = (ApplyRevisionsOptions)o;
        return Objects.equals(this.sourceFile, applyRevisionsOptions.sourceFile) && Objects.equals(this.revisions, applyRevisionsOptions.revisions) && Objects.equals(this.acceptAll, applyRevisionsOptions.acceptAll) && Objects.equals(this.rejectAll, applyRevisionsOptions.rejectAll) && Objects.equals(this.outputPath, applyRevisionsOptions.outputPath);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.revisions, this.acceptAll, this.rejectAll, this.outputPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplyRevisionsOptions {\n");
        sb.append("    sourceFile: ").append(this.toIndentedString(this.sourceFile)).append("\n");
        sb.append("    revisions: ").append(this.toIndentedString(this.revisions)).append("\n");
        sb.append("    acceptAll: ").append(this.toIndentedString(this.acceptAll)).append("\n");
        sb.append("    rejectAll: ").append(this.toIndentedString(this.rejectAll)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

