/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.comparison.model.PageInfo;
import com.groupdocs.cloud.comparison.model.Rectangle;
import com.groupdocs.cloud.comparison.model.StyleChangeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ChangeInfo Object fields")
public class ChangeInfo {
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="comparisonAction")
    private ComparisonActionEnum comparisonAction = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="targetText")
    private String targetText = null;
    @SerializedName(value="authors")
    private List<String> authors = null;
    @SerializedName(value="styleChangeInfo")
    private List<StyleChangeInfo> styleChangeInfo = null;
    @SerializedName(value="pageInfo")
    private PageInfo pageInfo = null;
    @SerializedName(value="box")
    private Rectangle box = null;

    public ChangeInfo id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Id of change")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ChangeInfo comparisonAction(ComparisonActionEnum comparisonAction) {
        this.comparisonAction = comparisonAction;
        return this;
    }

    @ApiModelProperty(required=true, value="Action (accept or reject). This field shows comparison what to do with this change")
    public ComparisonActionEnum getComparisonAction() {
        return this.comparisonAction;
    }

    public void setComparisonAction(ComparisonActionEnum comparisonAction) {
        this.comparisonAction = comparisonAction;
    }

    public ChangeInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of change (Inserted, Deleted or StyleChanged)")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ChangeInfo text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Text of changed element")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ChangeInfo targetText(String targetText) {
        this.targetText = targetText;
        return this;
    }

    @ApiModelProperty(value="Changed text of target doc")
    public String getTargetText() {
        return this.targetText;
    }

    public void setTargetText(String targetText) {
        this.targetText = targetText;
    }

    public ChangeInfo authors(List<String> authors) {
        this.authors = authors;
        return this;
    }

    public ChangeInfo addAuthorsItem(String authorsItem) {
        if (this.authors == null) {
            this.authors = new ArrayList<String>();
        }
        this.authors.add(authorsItem);
        return this;
    }

    @ApiModelProperty(value="Array of authors who made this change (used for multi comparison)")
    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public ChangeInfo styleChangeInfo(List<StyleChangeInfo> styleChangeInfo) {
        this.styleChangeInfo = styleChangeInfo;
        return this;
    }

    public ChangeInfo addStyleChangeInfoItem(StyleChangeInfo styleChangeInfoItem) {
        if (this.styleChangeInfo == null) {
            this.styleChangeInfo = new ArrayList<StyleChangeInfo>();
        }
        this.styleChangeInfo.add(styleChangeInfoItem);
        return this;
    }

    @ApiModelProperty(value="Array of style changes")
    public List<StyleChangeInfo> getStyleChangeInfo() {
        return this.styleChangeInfo;
    }

    public void setStyleChangeInfo(List<StyleChangeInfo> styleChangeInfo) {
        this.styleChangeInfo = styleChangeInfo;
    }

    public ChangeInfo pageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
        return this;
    }

    @ApiModelProperty(value="Page where current change is placed")
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public ChangeInfo box(Rectangle box) {
        this.box = box;
        return this;
    }

    @ApiModelProperty(required=true, value="Coordinates of changed element")
    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle box) {
        this.box = box;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeInfo changeInfo = (ChangeInfo)o;
        return Objects.equals(this.id, changeInfo.id) && Objects.equals((Object)this.comparisonAction, (Object)changeInfo.comparisonAction) && Objects.equals((Object)this.type, (Object)changeInfo.type) && Objects.equals(this.text, changeInfo.text) && Objects.equals(this.targetText, changeInfo.targetText) && Objects.equals(this.authors, changeInfo.authors) && Objects.equals(this.styleChangeInfo, changeInfo.styleChangeInfo) && Objects.equals(this.pageInfo, changeInfo.pageInfo) && Objects.equals(this.box, changeInfo.box);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.comparisonAction, this.type, this.text, this.targetText, this.authors, this.styleChangeInfo, this.pageInfo, this.box});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    comparisonAction: ").append(this.toIndentedString((Object)this.comparisonAction)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    targetText: ").append(this.toIndentedString(this.targetText)).append("\n");
        sb.append("    authors: ").append(this.toIndentedString(this.authors)).append("\n");
        sb.append("    styleChangeInfo: ").append(this.toIndentedString(this.styleChangeInfo)).append("\n");
        sb.append("    pageInfo: ").append(this.toIndentedString(this.pageInfo)).append("\n");
        sb.append("    box: ").append(this.toIndentedString(this.box)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NONE("None"),
        MODIFIED("Modified"),
        INSERTED("Inserted"),
        DELETED("Deleted"),
        ADDED("Added"),
        NOTMODIFIED("NotModified"),
        STYLECHANGED("StyleChanged"),
        RESIZED("Resized"),
        MOVED("Moved"),
        MOVEDANDRESIZED("MovedAndResized"),
        SHIFTEDANDRESIZED("ShiftedAndResized");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ComparisonActionEnum {
        NONE("None"),
        ACCEPT("Accept"),
        REJECT("Reject");

        private String value;

        private ComparisonActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ComparisonActionEnum fromValue(String text) {
            for (ComparisonActionEnum b : ComparisonActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ComparisonActionEnum> {
            public void write(JsonWriter jsonWriter, ComparisonActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ComparisonActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ComparisonActionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

