/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.comparison.model.FileInfo;
import com.groupdocs.cloud.comparison.model.Settings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines comparison options")
public class ComparisonOptions {
    @SerializedName(value="sourceFile")
    private FileInfo sourceFile = null;
    @SerializedName(value="targetFiles")
    private List<FileInfo> targetFiles = null;
    @SerializedName(value="settings")
    private Settings settings = null;
    @SerializedName(value="changeType")
    private ChangeTypeEnum changeType = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;

    public ComparisonOptions sourceFile(FileInfo sourceFile) {
        this.sourceFile = sourceFile;
        return this;
    }

    @ApiModelProperty(value="Information about source file")
    public FileInfo getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(FileInfo sourceFile) {
        this.sourceFile = sourceFile;
    }

    public ComparisonOptions targetFiles(List<FileInfo> targetFiles) {
        this.targetFiles = targetFiles;
        return this;
    }

    public ComparisonOptions addTargetFilesItem(FileInfo targetFilesItem) {
        if (this.targetFiles == null) {
            this.targetFiles = new ArrayList<FileInfo>();
        }
        this.targetFiles.add(targetFilesItem);
        return this;
    }

    @ApiModelProperty(value="Information about target file(s)")
    public List<FileInfo> getTargetFiles() {
        return this.targetFiles;
    }

    public void setTargetFiles(List<FileInfo> targetFiles) {
        this.targetFiles = targetFiles;
    }

    public ComparisonOptions settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(value="Comparison settings")
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public ComparisonOptions changeType(ChangeTypeEnum changeType) {
        this.changeType = changeType;
        return this;
    }

    @ApiModelProperty(required=true, value="Changes type. Used only for Changes resource(/comparison/changes)")
    public ChangeTypeEnum getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeTypeEnum changeType) {
        this.changeType = changeType;
    }

    public ComparisonOptions outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Path to the resultant document (if not specified the document will not be saved)")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonOptions comparisonOptions = (ComparisonOptions)o;
        return Objects.equals(this.sourceFile, comparisonOptions.sourceFile) && Objects.equals(this.targetFiles, comparisonOptions.targetFiles) && Objects.equals(this.settings, comparisonOptions.settings) && Objects.equals((Object)this.changeType, (Object)comparisonOptions.changeType) && Objects.equals(this.outputPath, comparisonOptions.outputPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceFile, this.targetFiles, this.settings, this.changeType, this.outputPath});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComparisonOptions {\n");
        sb.append("    sourceFile: ").append(this.toIndentedString(this.sourceFile)).append("\n");
        sb.append("    targetFiles: ").append(this.toIndentedString(this.targetFiles)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    changeType: ").append(this.toIndentedString((Object)this.changeType)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChangeTypeEnum {
        NONE("None"),
        MODIFIED("Modified"),
        INSERTED("Inserted"),
        DELETED("Deleted"),
        ADDED("Added"),
        NOTMODIFIED("NotModified"),
        STYLECHANGED("StyleChanged"),
        RESIZED("Resized"),
        MOVED("Moved"),
        MOVEDANDRESIZED("MovedAndResized"),
        SHIFTEDANDRESIZED("ShiftedAndResized");

        private String value;

        private ChangeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChangeTypeEnum fromValue(String text) {
            for (ChangeTypeEnum b : ChangeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ChangeTypeEnum> {
            public void write(JsonWriter jsonWriter, ChangeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChangeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChangeTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

