/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.comparison.model.FileInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines preview options")
public class PreviewOptions {
    @SerializedName(value="fileInfo")
    private FileInfo fileInfo = null;
    @SerializedName(value="format")
    private FormatEnum format = null;
    @SerializedName(value="outputFolder")
    private String outputFolder = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="pageNumbers")
    private List<Integer> pageNumbers = null;

    public PreviewOptions fileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    @ApiModelProperty(value="Input file info")
    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public PreviewOptions format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview image format")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public PreviewOptions outputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
        return this;
    }

    @ApiModelProperty(value="Path to folder with preview results")
    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public PreviewOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview width")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PreviewOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Preview height")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PreviewOptions pageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
        return this;
    }

    public PreviewOptions addPageNumbersItem(Integer pageNumbersItem) {
        if (this.pageNumbers == null) {
            this.pageNumbers = new ArrayList<Integer>();
        }
        this.pageNumbers.add(pageNumbersItem);
        return this;
    }

    @ApiModelProperty(value="Page numbers that will be previewed.")
    public List<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    public void setPageNumbers(List<Integer> pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreviewOptions previewOptions = (PreviewOptions)o;
        return Objects.equals(this.fileInfo, previewOptions.fileInfo) && Objects.equals((Object)this.format, (Object)previewOptions.format) && Objects.equals(this.outputFolder, previewOptions.outputFolder) && Objects.equals(this.width, previewOptions.width) && Objects.equals(this.height, previewOptions.height) && Objects.equals(this.pageNumbers, previewOptions.pageNumbers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileInfo, this.format, this.outputFolder, this.width, this.height, this.pageNumbers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreviewOptions {\n");
        sb.append("    fileInfo: ").append(this.toIndentedString(this.fileInfo)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    outputFolder: ").append(this.toIndentedString(this.outputFolder)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    pageNumbers: ").append(this.toIndentedString(this.pageNumbers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FormatEnum {
        JPEG("Jpeg"),
        PNG("Png"),
        BMP("Bmp");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FormatEnum fromValue(String text) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FormatEnum> {
            public void write(JsonWriter jsonWriter, FormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

