/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.comparison.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Provides information about one revision.")
public class RevisionInfo {
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="action")
    private ActionEnum action = null;
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="author")
    private String author = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public RevisionInfo id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Id of revision")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public RevisionInfo action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="Action (accept or reject). This field allows you to influence the display of the revision.             ")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public RevisionInfo text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="The text that is in revision.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public RevisionInfo author(String author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="Author.")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public RevisionInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="RevisionHandler type, depending on the type the Action (accept or reject) logic changes.             ")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionInfo revisionInfo = (RevisionInfo)o;
        return Objects.equals(this.id, revisionInfo.id) && Objects.equals((Object)this.action, (Object)revisionInfo.action) && Objects.equals(this.text, revisionInfo.text) && Objects.equals(this.author, revisionInfo.author) && Objects.equals((Object)this.type, (Object)revisionInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.action, this.text, this.author, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RevisionInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        INSERTION("Insertion"),
        DELETION("Deletion"),
        FORMATCHANGE("FormatChange"),
        STYLEDEFINITIONCHANGE("StyleDefinitionChange"),
        MOVING("Moving");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionEnum {
        NONE("None"),
        ACCEPT("Accept"),
        REJECT("Reject");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionEnum fromValue(String text) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionEnum> {
            public void write(JsonWriter jsonWriter, ActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

