/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.conversion.client.ApiCallback;
import com.groupdocs.cloud.conversion.client.ApiClient;
import com.groupdocs.cloud.conversion.client.ApiException;
import com.groupdocs.cloud.conversion.client.ApiResponse;
import com.groupdocs.cloud.conversion.client.Configuration;
import com.groupdocs.cloud.conversion.client.Pair;
import com.groupdocs.cloud.conversion.client.ProgressRequestBody;
import com.groupdocs.cloud.conversion.client.ProgressResponseBody;
import com.groupdocs.cloud.conversion.model.ConvertSettings;
import com.groupdocs.cloud.conversion.model.OperationResult;
import com.groupdocs.cloud.conversion.model.requests.GetOperationResultRequest;
import com.groupdocs.cloud.conversion.model.requests.GetOperationStatusRequest;
import com.groupdocs.cloud.conversion.model.requests.StartConvertAndSaveRequest;
import com.groupdocs.cloud.conversion.model.requests.StartConvertRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AsyncApi {
    private ApiClient apiClient;

    public AsyncApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public AsyncApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getOperationResultCall(GetOperationResultRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/async/result";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getid() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("id", request.getid()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOperationResultValidateBeforeCall(GetOperationResultRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getid() == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOperationResult(Async)");
        }
        Call call = this.getOperationResultCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File getOperationResult(GetOperationResultRequest request) throws ApiException {
        ApiResponse<File> resp = this.getOperationResultWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> getOperationResultWithHttpInfo(GetOperationResultRequest request) throws ApiException {
        Call call = this.getOperationResultValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOperationResultAsync(GetOperationResultRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOperationResultValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOperationStatusCall(GetOperationStatusRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getid() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("id", request.getid()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOperationStatusValidateBeforeCall(GetOperationStatusRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getid() == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOperationStatus(Async)");
        }
        Call call = this.getOperationStatusCall(request, progressListener, progressRequestListener);
        return call;
    }

    public OperationResult getOperationStatus(GetOperationStatusRequest request) throws ApiException {
        ApiResponse<OperationResult> resp = this.getOperationStatusWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<OperationResult> getOperationStatusWithHttpInfo(GetOperationStatusRequest request) throws ApiException {
        Call call = this.getOperationStatusValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<OperationResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOperationStatusAsync(GetOperationStatusRequest request, final ApiCallback<OperationResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOperationStatusValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OperationResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call startConvertCall(StartConvertRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/conversion/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getformat() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", request.getformat()));
        }
        if (request.getfromPage() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromPage", request.getfromPage()));
        }
        if (request.getpagesCount() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pagesCount", request.getpagesCount()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (request.getFile() != null) {
            localVarFormParams.put("File", request.getFile());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call startConvertValidateBeforeCall(StartConvertRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getformat() == null) {
            throw new ApiException("Missing the required parameter 'format' when calling startConvert(Async)");
        }
        if (request.getFile() == null) {
            throw new ApiException("Missing the required parameter 'file' when calling startConvert(Async)");
        }
        Call call = this.startConvertCall(request, progressListener, progressRequestListener);
        return call;
    }

    public String startConvert(StartConvertRequest request) throws ApiException {
        ApiResponse<String> resp = this.startConvertWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<String> startConvertWithHttpInfo(StartConvertRequest request) throws ApiException {
        Call call = this.startConvertValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call startConvertAsync(StartConvertRequest request, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startConvertValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call startConvertAndSaveCall(StartConvertAndSaveRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ConvertSettings localVarPostBody = request.getconvertSettings();
        String localVarPath = "/conversion/async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call startConvertAndSaveValidateBeforeCall(StartConvertAndSaveRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getconvertSettings() == null) {
            throw new ApiException("Missing the required parameter 'convertSettings' when calling startConvertAndSave(Async)");
        }
        Call call = this.startConvertAndSaveCall(request, progressListener, progressRequestListener);
        return call;
    }

    public String startConvertAndSave(StartConvertAndSaveRequest request) throws ApiException {
        ApiResponse<String> resp = this.startConvertAndSaveWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<String> startConvertAndSaveWithHttpInfo(StartConvertAndSaveRequest request) throws ApiException {
        Call call = this.startConvertAndSaveValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call startConvertAndSaveAsync(StartConvertAndSaveRequest request, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.startConvertAndSaveValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

