/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.conversion.client.ApiCallback;
import com.groupdocs.cloud.conversion.client.ApiClient;
import com.groupdocs.cloud.conversion.client.ApiException;
import com.groupdocs.cloud.conversion.client.ApiResponse;
import com.groupdocs.cloud.conversion.client.Configuration;
import com.groupdocs.cloud.conversion.client.Pair;
import com.groupdocs.cloud.conversion.client.ProgressRequestBody;
import com.groupdocs.cloud.conversion.client.ProgressResponseBody;
import com.groupdocs.cloud.conversion.model.DocumentMetadata;
import com.groupdocs.cloud.conversion.model.SupportedFormat;
import com.groupdocs.cloud.conversion.model.requests.GetDocumentMetadataRequest;
import com.groupdocs.cloud.conversion.model.requests.GetSupportedConversionTypesRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InfoApi {
    private ApiClient apiClient;

    public InfoApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public InfoApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getDocumentMetadataCall(GetDocumentMetadataRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getFilePath() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filePath", request.getFilePath()));
        }
        if (request.getStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getStorageName()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDocumentMetadataValidateBeforeCall(GetDocumentMetadataRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDocumentMetadataCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentMetadata getDocumentMetadata(GetDocumentMetadataRequest request) throws ApiException {
        ApiResponse<DocumentMetadata> resp = this.getDocumentMetadataWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentMetadata> getDocumentMetadataWithHttpInfo(GetDocumentMetadataRequest request) throws ApiException {
        Call call = this.getDocumentMetadataValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentMetadata>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDocumentMetadataAsync(GetDocumentMetadataRequest request, final ApiCallback<DocumentMetadata> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDocumentMetadataValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentMetadata>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSupportedConversionTypesCall(GetSupportedConversionTypesRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/formats";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getFilePath() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filePath", request.getFilePath()));
        }
        if (request.getStorageName() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storageName", request.getStorageName()));
        }
        if (request.getformat() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", request.getformat()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSupportedConversionTypesValidateBeforeCall(GetSupportedConversionTypesRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSupportedConversionTypesCall(request, progressListener, progressRequestListener);
        return call;
    }

    public List<SupportedFormat> getSupportedConversionTypes(GetSupportedConversionTypesRequest request) throws ApiException {
        ApiResponse<List<SupportedFormat>> resp = this.getSupportedConversionTypesWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<List<SupportedFormat>> getSupportedConversionTypesWithHttpInfo(GetSupportedConversionTypesRequest request) throws ApiException {
        Call call = this.getSupportedConversionTypesValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<List<SupportedFormat>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSupportedConversionTypesAsync(GetSupportedConversionTypesRequest request, final ApiCallback<List<SupportedFormat>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSupportedConversionTypesValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<SupportedFormat>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

