/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.SpreadsheetLoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Csv document load options")
public class CsvLoadOptions
extends SpreadsheetLoadOptions {
    @SerializedName(value="separator")
    private String separator = null;
    @SerializedName(value="isMultiEncoded")
    private Boolean isMultiEncoded = null;
    @SerializedName(value="hasFormula")
    private Boolean hasFormula = null;
    @SerializedName(value="convertNumericData")
    private Boolean convertNumericData = null;
    @SerializedName(value="convertDateTimeData")
    private Boolean convertDateTimeData = null;
    @SerializedName(value="encoding")
    private String encoding = null;

    public CsvLoadOptions separator(String separator) {
        this.separator = separator;
        return this;
    }

    @ApiModelProperty(required=true, value="Delimiter of a Csv file")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public CsvLoadOptions isMultiEncoded(Boolean isMultiEncoded) {
        this.isMultiEncoded = isMultiEncoded;
        return this;
    }

    @ApiModelProperty(required=true, value="True means the file contains several encodings")
    public Boolean getIsMultiEncoded() {
        return this.isMultiEncoded;
    }

    public void setIsMultiEncoded(Boolean isMultiEncoded) {
        this.isMultiEncoded = isMultiEncoded;
    }

    public CsvLoadOptions hasFormula(Boolean hasFormula) {
        this.hasFormula = hasFormula;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether text is formula if it starts with \"=\"")
    public Boolean getHasFormula() {
        return this.hasFormula;
    }

    public void setHasFormula(Boolean hasFormula) {
        this.hasFormula = hasFormula;
    }

    public CsvLoadOptions convertNumericData(Boolean convertNumericData) {
        this.convertNumericData = convertNumericData;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the string in the file is converted to numeric. Default is True")
    public Boolean getConvertNumericData() {
        return this.convertNumericData;
    }

    public void setConvertNumericData(Boolean convertNumericData) {
        this.convertNumericData = convertNumericData;
    }

    public CsvLoadOptions convertDateTimeData(Boolean convertDateTimeData) {
        this.convertDateTimeData = convertDateTimeData;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the string in the file is converted to date. Default is True")
    public Boolean getConvertDateTimeData() {
        return this.convertDateTimeData;
    }

    public void setConvertDateTimeData(Boolean convertDateTimeData) {
        this.convertDateTimeData = convertDateTimeData;
    }

    public CsvLoadOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="File encoding")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvLoadOptions csvLoadOptions = (CsvLoadOptions)o;
        return Objects.equals(this.separator, csvLoadOptions.separator) && Objects.equals(this.isMultiEncoded, csvLoadOptions.isMultiEncoded) && Objects.equals(this.hasFormula, csvLoadOptions.hasFormula) && Objects.equals(this.convertNumericData, csvLoadOptions.convertNumericData) && Objects.equals(this.convertDateTimeData, csvLoadOptions.convertDateTimeData) && Objects.equals(this.encoding, csvLoadOptions.encoding) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.separator, this.isMultiEncoded, this.hasFormula, this.convertNumericData, this.convertDateTimeData, this.encoding, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CsvLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("    isMultiEncoded: ").append(this.toIndentedString(this.isMultiEncoded)).append("\n");
        sb.append("    hasFormula: ").append(this.toIndentedString(this.hasFormula)).append("\n");
        sb.append("    convertNumericData: ").append(this.toIndentedString(this.convertNumericData)).append("\n");
        sb.append("    convertDateTimeData: ").append(this.toIndentedString(this.convertDateTimeData)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

