/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Pdf document load options")
public class PdfLoadOptions
extends LoadOptions {
    @SerializedName(value="clearBuiltInDocumentProperties")
    private Boolean clearBuiltInDocumentProperties = null;
    @SerializedName(value="clearCustomDocumentProperties")
    private Boolean clearCustomDocumentProperties = null;
    @SerializedName(value="pageNumbering")
    private Boolean pageNumbering = null;
    @SerializedName(value="flattenAllFields")
    private Boolean flattenAllFields = null;
    @SerializedName(value="hidePdfAnnotations")
    private Boolean hidePdfAnnotations = null;
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="removeJavascript")
    private Boolean removeJavascript = null;
    @SerializedName(value="removeEmbeddedFiles")
    private Boolean removeEmbeddedFiles = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;

    public PdfLoadOptions clearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear built-in document properties")
    public Boolean getClearBuiltInDocumentProperties() {
        return this.clearBuiltInDocumentProperties;
    }

    public void setClearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
    }

    public PdfLoadOptions clearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear custom document properties")
    public Boolean getClearCustomDocumentProperties() {
        return this.clearCustomDocumentProperties;
    }

    public void setClearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
    }

    public PdfLoadOptions pageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
        return this;
    }

    @ApiModelProperty(required=true, value="Enable or disable generation of page numbering in converted document. Default:     false")
    public Boolean getPageNumbering() {
        return this.pageNumbering;
    }

    public void setPageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
    }

    public PdfLoadOptions flattenAllFields(Boolean flattenAllFields) {
        this.flattenAllFields = flattenAllFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Flatten all the fields of the PDF form")
    public Boolean getFlattenAllFields() {
        return this.flattenAllFields;
    }

    public void setFlattenAllFields(Boolean flattenAllFields) {
        this.flattenAllFields = flattenAllFields;
    }

    public PdfLoadOptions hidePdfAnnotations(Boolean hidePdfAnnotations) {
        this.hidePdfAnnotations = hidePdfAnnotations;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide annotations in Pdf documents")
    public Boolean getHidePdfAnnotations() {
        return this.hidePdfAnnotations;
    }

    public void setHidePdfAnnotations(Boolean hidePdfAnnotations) {
        this.hidePdfAnnotations = hidePdfAnnotations;
    }

    public PdfLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Pdf document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public PdfLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PdfLoadOptions removeJavascript(Boolean removeJavascript) {
        this.removeJavascript = removeJavascript;
        return this;
    }

    @ApiModelProperty(required=true, value="Remove javascript")
    public Boolean getRemoveJavascript() {
        return this.removeJavascript;
    }

    public void setRemoveJavascript(Boolean removeJavascript) {
        this.removeJavascript = removeJavascript;
    }

    public PdfLoadOptions removeEmbeddedFiles(Boolean removeEmbeddedFiles) {
        this.removeEmbeddedFiles = removeEmbeddedFiles;
        return this;
    }

    @ApiModelProperty(required=true, value="Remove embedded files")
    public Boolean getRemoveEmbeddedFiles() {
        return this.removeEmbeddedFiles;
    }

    public void setRemoveEmbeddedFiles(Boolean removeEmbeddedFiles) {
        this.removeEmbeddedFiles = removeEmbeddedFiles;
    }

    public PdfLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public PdfLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Words document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfLoadOptions pdfLoadOptions = (PdfLoadOptions)o;
        return Objects.equals(this.clearBuiltInDocumentProperties, pdfLoadOptions.clearBuiltInDocumentProperties) && Objects.equals(this.clearCustomDocumentProperties, pdfLoadOptions.clearCustomDocumentProperties) && Objects.equals(this.pageNumbering, pdfLoadOptions.pageNumbering) && Objects.equals(this.flattenAllFields, pdfLoadOptions.flattenAllFields) && Objects.equals(this.hidePdfAnnotations, pdfLoadOptions.hidePdfAnnotations) && Objects.equals(this.defaultFont, pdfLoadOptions.defaultFont) && Objects.equals(this.password, pdfLoadOptions.password) && Objects.equals(this.removeJavascript, pdfLoadOptions.removeJavascript) && Objects.equals(this.removeEmbeddedFiles, pdfLoadOptions.removeEmbeddedFiles) && Objects.equals(this.fontSubstitutes, pdfLoadOptions.fontSubstitutes) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clearBuiltInDocumentProperties, this.clearCustomDocumentProperties, this.pageNumbering, this.flattenAllFields, this.hidePdfAnnotations, this.defaultFont, this.password, this.removeJavascript, this.removeEmbeddedFiles, this.fontSubstitutes, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    clearBuiltInDocumentProperties: ").append(this.toIndentedString(this.clearBuiltInDocumentProperties)).append("\n");
        sb.append("    clearCustomDocumentProperties: ").append(this.toIndentedString(this.clearCustomDocumentProperties)).append("\n");
        sb.append("    pageNumbering: ").append(this.toIndentedString(this.pageNumbering)).append("\n");
        sb.append("    flattenAllFields: ").append(this.toIndentedString(this.flattenAllFields)).append("\n");
        sb.append("    hidePdfAnnotations: ").append(this.toIndentedString(this.hidePdfAnnotations)).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    removeJavascript: ").append(this.toIndentedString(this.removeJavascript)).append("\n");
        sb.append("    removeEmbeddedFiles: ").append(this.toIndentedString(this.removeEmbeddedFiles)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

