/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Options for to Html conversion")
public class WebConvertOptions
extends ConvertOptions {
    @SerializedName(value="usePdf")
    private Boolean usePdf = null;
    @SerializedName(value="fixedLayout")
    private Boolean fixedLayout = null;
    @SerializedName(value="fixedLayoutShowBorders")
    private Boolean fixedLayoutShowBorders = null;
    @SerializedName(value="zoom")
    private Integer zoom = null;

    public WebConvertOptions usePdf(Boolean usePdf) {
        this.usePdf = usePdf;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, the input firstly is converted to PDF and after that to desired format")
    public Boolean getUsePdf() {
        return this.usePdf;
    }

    public void setUsePdf(Boolean usePdf) {
        this.usePdf = usePdf;
    }

    public WebConvertOptions fixedLayout(Boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="If true fixed layout will be used e.g. absolutely positioned html elements Default:  true")
    public Boolean getFixedLayout() {
        return this.fixedLayout;
    }

    public void setFixedLayout(Boolean fixedLayout) {
        this.fixedLayout = fixedLayout;
    }

    public WebConvertOptions fixedLayoutShowBorders(Boolean fixedLayoutShowBorders) {
        this.fixedLayoutShowBorders = fixedLayoutShowBorders;
        return this;
    }

    @ApiModelProperty(required=true, value="Show page borders when converting to fixed layout. Default is True")
    public Boolean getFixedLayoutShowBorders() {
        return this.fixedLayoutShowBorders;
    }

    public void setFixedLayoutShowBorders(Boolean fixedLayoutShowBorders) {
        this.fixedLayoutShowBorders = fixedLayoutShowBorders;
    }

    public WebConvertOptions zoom(Integer zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the zoom level in percentage. Default is 100.")
    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebConvertOptions webConvertOptions = (WebConvertOptions)o;
        return Objects.equals(this.usePdf, webConvertOptions.usePdf) && Objects.equals(this.fixedLayout, webConvertOptions.fixedLayout) && Objects.equals(this.fixedLayoutShowBorders, webConvertOptions.fixedLayoutShowBorders) && Objects.equals(this.zoom, webConvertOptions.zoom) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.usePdf, this.fixedLayout, this.fixedLayoutShowBorders, this.zoom, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    usePdf: ").append(this.toIndentedString(this.usePdf)).append("\n");
        sb.append("    fixedLayout: ").append(this.toIndentedString(this.fixedLayout)).append("\n");
        sb.append("    fixedLayoutShowBorders: ").append(this.toIndentedString(this.fixedLayoutShowBorders)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

