/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Options for to word processing conversion")
public class WordProcessingConvertOptions
extends ConvertOptions {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="dpi")
    private Integer dpi = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="zoom")
    private Integer zoom = null;
    @SerializedName(value="pdfRecognitionMode")
    private PdfRecognitionModeEnum pdfRecognitionMode = null;
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="pageOrientation")
    private PageOrientationEnum pageOrientation = null;

    public WordProcessingConvertOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page width after conversion")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public WordProcessingConvertOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page height after conversion")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public WordProcessingConvertOptions dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page DPI after conversion. The default resolution is: 96dpi")
    public Integer getDpi() {
        return this.dpi;
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public WordProcessingConvertOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set this property if you want to protect the converted document with a password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WordProcessingConvertOptions zoom(Integer zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the zoom level in percentage. Default is 100. Default zoom is supported till Microsoft Word 2010. Starting from Microsoft Word 2013 default zoom is no longer set to document, instead it appears to use the zoom factor of the last document that was opened.")
    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public WordProcessingConvertOptions pdfRecognitionMode(PdfRecognitionModeEnum pdfRecognitionMode) {
        this.pdfRecognitionMode = pdfRecognitionMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Recognition mode when converting from pdf")
    public PdfRecognitionModeEnum getPdfRecognitionMode() {
        return this.pdfRecognitionMode;
    }

    public void setPdfRecognitionMode(PdfRecognitionModeEnum pdfRecognitionMode) {
        this.pdfRecognitionMode = pdfRecognitionMode;
    }

    public WordProcessingConvertOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Page size")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public WordProcessingConvertOptions pageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies page orientation")
    public PageOrientationEnum getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordProcessingConvertOptions wordProcessingConvertOptions = (WordProcessingConvertOptions)o;
        return Objects.equals(this.width, wordProcessingConvertOptions.width) && Objects.equals(this.height, wordProcessingConvertOptions.height) && Objects.equals(this.dpi, wordProcessingConvertOptions.dpi) && Objects.equals(this.password, wordProcessingConvertOptions.password) && Objects.equals(this.zoom, wordProcessingConvertOptions.zoom) && Objects.equals((Object)this.pdfRecognitionMode, (Object)wordProcessingConvertOptions.pdfRecognitionMode) && Objects.equals((Object)this.pageSize, (Object)wordProcessingConvertOptions.pageSize) && Objects.equals((Object)this.pageOrientation, (Object)wordProcessingConvertOptions.pageOrientation) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.dpi, this.password, this.zoom, this.pdfRecognitionMode, this.pageSize, this.pageOrientation, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordProcessingConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("    pdfRecognitionMode: ").append(this.toIndentedString((Object)this.pdfRecognitionMode)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    pageOrientation: ").append(this.toIndentedString((Object)this.pageOrientation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageOrientationEnum {
        DEFAULT("Default"),
        LANDSCAPE("Landscape"),
        PORTRAIT("Portrait");

        private String value;

        private PageOrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageOrientationEnum fromValue(String text) {
            for (PageOrientationEnum b : PageOrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageOrientationEnum> {
            public void write(JsonWriter jsonWriter, PageOrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageOrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageOrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        DEFAULT("Default"),
        A3("A3"),
        STATEMENT("Statement"),
        QUARTO("Quarto"),
        PAPER11X17("Paper11x17"),
        PAPER10X14("Paper10x14"),
        LETTER("Letter"),
        LEGAL("Legal"),
        LEDGER("Ledger"),
        FOLIO("Folio"),
        EXECUTIVE("Executive"),
        ENVELOPEDL("EnvelopeDL"),
        CUSTOM("Custom"),
        B5("B5"),
        B4("B4"),
        A5("A5"),
        A4("A4"),
        TABLOID("Tabloid");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PdfRecognitionModeEnum {
        TEXTBOX("Textbox"),
        FLOW("Flow");

        private String value;

        private PdfRecognitionModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PdfRecognitionModeEnum fromValue(String text) {
            for (PdfRecognitionModeEnum b : PdfRecognitionModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PdfRecognitionModeEnum> {
            public void write(JsonWriter jsonWriter, PdfRecognitionModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PdfRecognitionModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PdfRecognitionModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

