/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.FieldLabel;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options for loading Email documents")
public class EmailLoadOptions
extends LoadOptions {
    @SerializedName(value="displayHeader")
    private Boolean displayHeader = null;
    @SerializedName(value="displayFromEmailAddress")
    private Boolean displayFromEmailAddress = null;
    @SerializedName(value="displayToEmailAddress")
    private Boolean displayToEmailAddress = null;
    @SerializedName(value="displayCcEmailAddress")
    private Boolean displayCcEmailAddress = null;
    @SerializedName(value="displayBccEmailAddress")
    private Boolean displayBccEmailAddress = null;
    @SerializedName(value="timeZoneOffset")
    private String timeZoneOffset = null;
    @SerializedName(value="convertAttachments")
    private Boolean convertAttachments = null;
    @SerializedName(value="fieldLabels")
    private List<FieldLabel> fieldLabels = null;
    @SerializedName(value="preserveOriginalDate")
    private Boolean preserveOriginalDate = null;

    public EmailLoadOptions displayHeader(Boolean displayHeader) {
        this.displayHeader = displayHeader;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide the email header. Default: true")
    public Boolean getDisplayHeader() {
        return this.displayHeader;
    }

    public void setDisplayHeader(Boolean displayHeader) {
        this.displayHeader = displayHeader;
    }

    public EmailLoadOptions displayFromEmailAddress(Boolean displayFromEmailAddress) {
        this.displayFromEmailAddress = displayFromEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"from\" email address. Default: true")
    public Boolean getDisplayFromEmailAddress() {
        return this.displayFromEmailAddress;
    }

    public void setDisplayFromEmailAddress(Boolean displayFromEmailAddress) {
        this.displayFromEmailAddress = displayFromEmailAddress;
    }

    public EmailLoadOptions displayToEmailAddress(Boolean displayToEmailAddress) {
        this.displayToEmailAddress = displayToEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"to\" email address. Default: true")
    public Boolean getDisplayToEmailAddress() {
        return this.displayToEmailAddress;
    }

    public void setDisplayToEmailAddress(Boolean displayToEmailAddress) {
        this.displayToEmailAddress = displayToEmailAddress;
    }

    public EmailLoadOptions displayCcEmailAddress(Boolean displayCcEmailAddress) {
        this.displayCcEmailAddress = displayCcEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"Cc\" email address. Default: false")
    public Boolean getDisplayCcEmailAddress() {
        return this.displayCcEmailAddress;
    }

    public void setDisplayCcEmailAddress(Boolean displayCcEmailAddress) {
        this.displayCcEmailAddress = displayCcEmailAddress;
    }

    public EmailLoadOptions displayBccEmailAddress(Boolean displayBccEmailAddress) {
        this.displayBccEmailAddress = displayBccEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"Bcc\" email address. Default: false")
    public Boolean getDisplayBccEmailAddress() {
        return this.displayBccEmailAddress;
    }

    public void setDisplayBccEmailAddress(Boolean displayBccEmailAddress) {
        this.displayBccEmailAddress = displayBccEmailAddress;
    }

    public EmailLoadOptions timeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the Coordinated Universal Time (UTC) offset for the message dates. This property defines the time zone difference, between the localtime and UTC.")
    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public EmailLoadOptions convertAttachments(Boolean convertAttachments) {
        this.convertAttachments = convertAttachments;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to convert attachments in source email or not. Default: false.")
    public Boolean getConvertAttachments() {
        return this.convertAttachments;
    }

    public void setConvertAttachments(Boolean convertAttachments) {
        this.convertAttachments = convertAttachments;
    }

    public EmailLoadOptions fieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
        return this;
    }

    public EmailLoadOptions addFieldLabelsItem(FieldLabel fieldLabelsItem) {
        if (this.fieldLabels == null) {
            this.fieldLabels = new ArrayList<FieldLabel>();
        }
        this.fieldLabels.add(fieldLabelsItem);
        return this;
    }

    @ApiModelProperty(value="The mapping between email message field and field text representation")
    public List<FieldLabel> getFieldLabels() {
        return this.fieldLabels;
    }

    public void setFieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public EmailLoadOptions preserveOriginalDate(Boolean preserveOriginalDate) {
        this.preserveOriginalDate = preserveOriginalDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines whether need to keep original date header string in mail message when saving or not (Default value is true)")
    public Boolean getPreserveOriginalDate() {
        return this.preserveOriginalDate;
    }

    public void setPreserveOriginalDate(Boolean preserveOriginalDate) {
        this.preserveOriginalDate = preserveOriginalDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailLoadOptions emailLoadOptions = (EmailLoadOptions)o;
        return Objects.equals(this.displayHeader, emailLoadOptions.displayHeader) && Objects.equals(this.displayFromEmailAddress, emailLoadOptions.displayFromEmailAddress) && Objects.equals(this.displayToEmailAddress, emailLoadOptions.displayToEmailAddress) && Objects.equals(this.displayCcEmailAddress, emailLoadOptions.displayCcEmailAddress) && Objects.equals(this.displayBccEmailAddress, emailLoadOptions.displayBccEmailAddress) && Objects.equals(this.timeZoneOffset, emailLoadOptions.timeZoneOffset) && Objects.equals(this.convertAttachments, emailLoadOptions.convertAttachments) && Objects.equals(this.fieldLabels, emailLoadOptions.fieldLabels) && Objects.equals(this.preserveOriginalDate, emailLoadOptions.preserveOriginalDate) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.displayHeader, this.displayFromEmailAddress, this.displayToEmailAddress, this.displayCcEmailAddress, this.displayBccEmailAddress, this.timeZoneOffset, this.convertAttachments, this.fieldLabels, this.preserveOriginalDate, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    displayHeader: ").append(this.toIndentedString(this.displayHeader)).append("\n");
        sb.append("    displayFromEmailAddress: ").append(this.toIndentedString(this.displayFromEmailAddress)).append("\n");
        sb.append("    displayToEmailAddress: ").append(this.toIndentedString(this.displayToEmailAddress)).append("\n");
        sb.append("    displayCcEmailAddress: ").append(this.toIndentedString(this.displayCcEmailAddress)).append("\n");
        sb.append("    displayBccEmailAddress: ").append(this.toIndentedString(this.displayBccEmailAddress)).append("\n");
        sb.append("    timeZoneOffset: ").append(this.toIndentedString(this.timeZoneOffset)).append("\n");
        sb.append("    convertAttachments: ").append(this.toIndentedString(this.convertAttachments)).append("\n");
        sb.append("    fieldLabels: ").append(this.toIndentedString(this.fieldLabels)).append("\n");
        sb.append("    preserveOriginalDate: ").append(this.toIndentedString(this.preserveOriginalDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

