/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Presentation document load options")
public class PresentationLoadOptions
extends LoadOptions {
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="hideComments")
    private Boolean hideComments = null;
    @SerializedName(value="showHiddenSlides")
    private Boolean showHiddenSlides = null;

    public PresentationLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for rendering the presentation. The following font will be used if a presentation font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public PresentationLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public PresentationLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Slides document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public PresentationLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PresentationLoadOptions hideComments(Boolean hideComments) {
        this.hideComments = hideComments;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide comments")
    public Boolean getHideComments() {
        return this.hideComments;
    }

    public void setHideComments(Boolean hideComments) {
        this.hideComments = hideComments;
    }

    public PresentationLoadOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(required=true, value="Show hidden slides")
    public Boolean getShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentationLoadOptions presentationLoadOptions = (PresentationLoadOptions)o;
        return Objects.equals(this.defaultFont, presentationLoadOptions.defaultFont) && Objects.equals(this.fontSubstitutes, presentationLoadOptions.fontSubstitutes) && Objects.equals(this.password, presentationLoadOptions.password) && Objects.equals(this.hideComments, presentationLoadOptions.hideComments) && Objects.equals(this.showHiddenSlides, presentationLoadOptions.showHiddenSlides) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultFont, this.fontSubstitutes, this.password, this.hideComments, this.showHiddenSlides, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentationLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    hideComments: ").append(this.toIndentedString(this.hideComments)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

