/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Spreadsheet document load options")
public class SpreadsheetLoadOptions
extends LoadOptions {
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="showGridLines")
    private Boolean showGridLines = null;
    @SerializedName(value="showHiddenSheets")
    private Boolean showHiddenSheets = null;
    @SerializedName(value="onePagePerSheet")
    private Boolean onePagePerSheet = null;
    @SerializedName(value="convertRange")
    private String convertRange = null;
    @SerializedName(value="skipEmptyRowsAndColumns")
    private Boolean skipEmptyRowsAndColumns = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="hideComments")
    private Boolean hideComments = null;

    public SpreadsheetLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Cells document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public SpreadsheetLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public SpreadsheetLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Cells document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public SpreadsheetLoadOptions showGridLines(Boolean showGridLines) {
        this.showGridLines = showGridLines;
        return this;
    }

    @ApiModelProperty(required=true, value="Show grid lines when converting Excel files")
    public Boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(Boolean showGridLines) {
        this.showGridLines = showGridLines;
    }

    public SpreadsheetLoadOptions showHiddenSheets(Boolean showHiddenSheets) {
        this.showHiddenSheets = showHiddenSheets;
        return this;
    }

    @ApiModelProperty(required=true, value="Show hidden sheets when converting Excel files")
    public Boolean getShowHiddenSheets() {
        return this.showHiddenSheets;
    }

    public void setShowHiddenSheets(Boolean showHiddenSheets) {
        this.showHiddenSheets = showHiddenSheets;
    }

    public SpreadsheetLoadOptions onePagePerSheet(Boolean onePagePerSheet) {
        this.onePagePerSheet = onePagePerSheet;
        return this;
    }

    @ApiModelProperty(required=true, value="If OnePagePerSheet is true the content of the sheet will be converted to one page in the PDF document. Default value is true.")
    public Boolean getOnePagePerSheet() {
        return this.onePagePerSheet;
    }

    public void setOnePagePerSheet(Boolean onePagePerSheet) {
        this.onePagePerSheet = onePagePerSheet;
    }

    public SpreadsheetLoadOptions convertRange(String convertRange) {
        this.convertRange = convertRange;
        return this;
    }

    @ApiModelProperty(value="Convert specific range when converting to other than cells format. Example: \"D1:F8\"")
    public String getConvertRange() {
        return this.convertRange;
    }

    public void setConvertRange(String convertRange) {
        this.convertRange = convertRange;
    }

    public SpreadsheetLoadOptions skipEmptyRowsAndColumns(Boolean skipEmptyRowsAndColumns) {
        this.skipEmptyRowsAndColumns = skipEmptyRowsAndColumns;
        return this;
    }

    @ApiModelProperty(required=true, value="Skips empty rows and columns when converting. Default is True.")
    public Boolean getSkipEmptyRowsAndColumns() {
        return this.skipEmptyRowsAndColumns;
    }

    public void setSkipEmptyRowsAndColumns(Boolean skipEmptyRowsAndColumns) {
        this.skipEmptyRowsAndColumns = skipEmptyRowsAndColumns;
    }

    public SpreadsheetLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SpreadsheetLoadOptions hideComments(Boolean hideComments) {
        this.hideComments = hideComments;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide comments")
    public Boolean getHideComments() {
        return this.hideComments;
    }

    public void setHideComments(Boolean hideComments) {
        this.hideComments = hideComments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetLoadOptions spreadsheetLoadOptions = (SpreadsheetLoadOptions)o;
        return Objects.equals(this.defaultFont, spreadsheetLoadOptions.defaultFont) && Objects.equals(this.fontSubstitutes, spreadsheetLoadOptions.fontSubstitutes) && Objects.equals(this.showGridLines, spreadsheetLoadOptions.showGridLines) && Objects.equals(this.showHiddenSheets, spreadsheetLoadOptions.showHiddenSheets) && Objects.equals(this.onePagePerSheet, spreadsheetLoadOptions.onePagePerSheet) && Objects.equals(this.convertRange, spreadsheetLoadOptions.convertRange) && Objects.equals(this.skipEmptyRowsAndColumns, spreadsheetLoadOptions.skipEmptyRowsAndColumns) && Objects.equals(this.password, spreadsheetLoadOptions.password) && Objects.equals(this.hideComments, spreadsheetLoadOptions.hideComments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultFont, this.fontSubstitutes, this.showGridLines, this.showHiddenSheets, this.onePagePerSheet, this.convertRange, this.skipEmptyRowsAndColumns, this.password, this.hideComments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    showGridLines: ").append(this.toIndentedString(this.showGridLines)).append("\n");
        sb.append("    showHiddenSheets: ").append(this.toIndentedString(this.showHiddenSheets)).append("\n");
        sb.append("    onePagePerSheet: ").append(this.toIndentedString(this.onePagePerSheet)).append("\n");
        sb.append("    convertRange: ").append(this.toIndentedString(this.convertRange)).append("\n");
        sb.append("    skipEmptyRowsAndColumns: ").append(this.toIndentedString(this.skipEmptyRowsAndColumns)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    hideComments: ").append(this.toIndentedString(this.hideComments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

