/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains single converted item. Result is provided as url to a storage")
public class StoredConvertedResult {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="url")
    private String url = null;

    public StoredConvertedResult name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of converted item")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StoredConvertedResult size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Size of converted item")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public StoredConvertedResult path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Path of resource file in storage")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public StoredConvertedResult url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Uri in the storage of the converted item")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredConvertedResult storedConvertedResult = (StoredConvertedResult)o;
        return Objects.equals(this.name, storedConvertedResult.name) && Objects.equals(this.size, storedConvertedResult.size) && Objects.equals(this.path, storedConvertedResult.path) && Objects.equals(this.url, storedConvertedResult.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size, this.path, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredConvertedResult {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

