/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="WordProcessing document load options")
public class WordProcessingLoadOptions
extends LoadOptions {
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="autoFontSubstitution")
    private Boolean autoFontSubstitution = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="hideWordTrackedChanges")
    private Boolean hideWordTrackedChanges = null;
    @SerializedName(value="hideComments")
    private Boolean hideComments = null;
    @SerializedName(value="bookmarksOutlineLevel")
    private Integer bookmarksOutlineLevel = null;
    @SerializedName(value="headingsOutlineLevels")
    private Integer headingsOutlineLevels = null;
    @SerializedName(value="expandedOutlineLevels")
    private Integer expandedOutlineLevels = null;

    public WordProcessingLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Words document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public WordProcessingLoadOptions autoFontSubstitution(Boolean autoFontSubstitution) {
        this.autoFontSubstitution = autoFontSubstitution;
        return this;
    }

    @ApiModelProperty(required=true, value="If AutoFontSubstitution is disabled, GroupDocs.Conversion uses the DefaultFont for the substitution of missing fonts. If AutoFontSubstitution is enabled, GroupDocs.Conversion evaluates all the related fields in FontInfo (Panose, Sig etc) for the missing font and finds the closest match among the available font sources. Note that font substitution mechanism will override the DefaultFont in cases when FontInfo for the missing font is available in the document. The default value is True.")
    public Boolean getAutoFontSubstitution() {
        return this.autoFontSubstitution;
    }

    public void setAutoFontSubstitution(Boolean autoFontSubstitution) {
        this.autoFontSubstitution = autoFontSubstitution;
    }

    public WordProcessingLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public WordProcessingLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Words document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public WordProcessingLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WordProcessingLoadOptions hideWordTrackedChanges(Boolean hideWordTrackedChanges) {
        this.hideWordTrackedChanges = hideWordTrackedChanges;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide markup and track changes for Word documents")
    public Boolean getHideWordTrackedChanges() {
        return this.hideWordTrackedChanges;
    }

    public void setHideWordTrackedChanges(Boolean hideWordTrackedChanges) {
        this.hideWordTrackedChanges = hideWordTrackedChanges;
    }

    public WordProcessingLoadOptions hideComments(Boolean hideComments) {
        this.hideComments = hideComments;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide comments")
    public Boolean getHideComments() {
        return this.hideComments;
    }

    public void setHideComments(Boolean hideComments) {
        this.hideComments = hideComments;
    }

    public WordProcessingLoadOptions bookmarksOutlineLevel(Integer bookmarksOutlineLevel) {
        this.bookmarksOutlineLevel = bookmarksOutlineLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the default level in the document outline at which to display Word bookmarks. Default is 0. Valid range is 0 to 9.")
    public Integer getBookmarksOutlineLevel() {
        return this.bookmarksOutlineLevel;
    }

    public void setBookmarksOutlineLevel(Integer bookmarksOutlineLevel) {
        this.bookmarksOutlineLevel = bookmarksOutlineLevel;
    }

    public WordProcessingLoadOptions headingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies how many levels of headings (paragraphs formatted with the Heading styles) to include in the document outline. Default is 0. Valid range is 0 to 9.")
    public Integer getHeadingsOutlineLevels() {
        return this.headingsOutlineLevels;
    }

    public void setHeadingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
    }

    public WordProcessingLoadOptions expandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies how many levels in the document outline to show expanded when the file is viewed. Default is 0. Valid range is 0 to 9. Note that this options will not work when saving to XPS.")
    public Integer getExpandedOutlineLevels() {
        return this.expandedOutlineLevels;
    }

    public void setExpandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordProcessingLoadOptions wordProcessingLoadOptions = (WordProcessingLoadOptions)o;
        return Objects.equals(this.defaultFont, wordProcessingLoadOptions.defaultFont) && Objects.equals(this.autoFontSubstitution, wordProcessingLoadOptions.autoFontSubstitution) && Objects.equals(this.fontSubstitutes, wordProcessingLoadOptions.fontSubstitutes) && Objects.equals(this.password, wordProcessingLoadOptions.password) && Objects.equals(this.hideWordTrackedChanges, wordProcessingLoadOptions.hideWordTrackedChanges) && Objects.equals(this.hideComments, wordProcessingLoadOptions.hideComments) && Objects.equals(this.bookmarksOutlineLevel, wordProcessingLoadOptions.bookmarksOutlineLevel) && Objects.equals(this.headingsOutlineLevels, wordProcessingLoadOptions.headingsOutlineLevels) && Objects.equals(this.expandedOutlineLevels, wordProcessingLoadOptions.expandedOutlineLevels) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultFont, this.autoFontSubstitution, this.fontSubstitutes, this.password, this.hideWordTrackedChanges, this.hideComments, this.bookmarksOutlineLevel, this.headingsOutlineLevels, this.expandedOutlineLevels, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordProcessingLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    autoFontSubstitution: ").append(this.toIndentedString(this.autoFontSubstitution)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    hideWordTrackedChanges: ").append(this.toIndentedString(this.hideWordTrackedChanges)).append("\n");
        sb.append("    hideComments: ").append(this.toIndentedString(this.hideComments)).append("\n");
        sb.append("    bookmarksOutlineLevel: ").append(this.toIndentedString(this.bookmarksOutlineLevel)).append("\n");
        sb.append("    headingsOutlineLevels: ").append(this.toIndentedString(this.headingsOutlineLevels)).append("\n");
        sb.append("    expandedOutlineLevels: ").append(this.toIndentedString(this.expandedOutlineLevels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

