/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model.requests;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Objects;

public class ConvertDocumentDirectRequest {
    @SerializedName(value="format")
    private String format = null;
    @SerializedName(value="file")
    private File file = null;
    @SerializedName(value="fromPage")
    private Integer fromPage = null;
    @SerializedName(value="pagesCount")
    private Integer pagesCount = null;
    @SerializedName(value="loadOptions")
    private LoadOptions loadOptions = null;
    @SerializedName(value="convertOptions")
    private ConvertOptions convertOptions = null;

    public ConvertDocumentDirectRequest() {
    }

    public ConvertDocumentDirectRequest(String format, File file, Integer fromPage, Integer pagesCount, LoadOptions loadOptions, ConvertOptions convertOptions) {
        this.format = format;
        this.file = file;
        this.fromPage = fromPage;
        this.pagesCount = pagesCount;
        this.loadOptions = loadOptions;
        this.convertOptions = convertOptions;
    }

    @ApiModelProperty(example="format_example", required=true, value="Requested conversion format")
    public String getformat() {
        return this.format;
    }

    public void setformat(String format) {
        this.format = format;
    }

    @ApiModelProperty(example="new File(&quot;/path/to/file.txt&quot;)", required=true, value="Input file to convert")
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @ApiModelProperty(example="1", value="Page start conversion from")
    public Integer getfromPage() {
        return this.fromPage;
    }

    public void setfromPage(Integer fromPage) {
        this.fromPage = fromPage;
    }

    @ApiModelProperty(example="0", value="Number of pages to convert")
    public Integer getpagesCount() {
        return this.pagesCount;
    }

    public void setpagesCount(Integer pagesCount) {
        this.pagesCount = pagesCount;
    }

    @ApiModelProperty(example="loadOptions_example", value="Input file load options")
    public LoadOptions getloadOptions() {
        return this.loadOptions;
    }

    public void setloadOptions(LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
    }

    @ApiModelProperty(example="convertOptions_example", value="Conversion options")
    public ConvertOptions getconvertOptions() {
        return this.convertOptions;
    }

    public void setconvertOptions(ConvertOptions convertOptions) {
        this.convertOptions = convertOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertDocumentDirectRequest request = (ConvertDocumentDirectRequest)o;
        return Objects.equals(this.format, request.format) && Objects.equals(this.file, request.file) && Objects.equals(this.fromPage, request.fromPage) && Objects.equals(this.pagesCount, request.pagesCount) && Objects.equals(this.loadOptions, request.loadOptions) && Objects.equals(this.convertOptions, request.convertOptions);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.file, this.fromPage, this.pagesCount, this.loadOptions, this.convertOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertDocumentDirect {\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    file: ").append(this.toIndentedString(this.file)).append("\n");
        sb.append("    fromPage: ").append(this.toIndentedString(this.fromPage)).append("\n");
        sb.append("    pagesCount: ").append(this.toIndentedString(this.pagesCount)).append("\n");
        sb.append("    loadOptions: ").append(this.toIndentedString(this.loadOptions)).append("\n");
        sb.append("    convertOptions: ").append(this.toIndentedString(this.convertOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

