/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Contains a document metadata ")
public class DocumentMetadata {
    @SerializedName(value="fileType")
    private String fileType = null;
    @SerializedName(value="pageCount")
    private Integer pageCount = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="horizontalResolution")
    private Integer horizontalResolution = null;
    @SerializedName(value="verticalResolution")
    private Integer verticalResolution = null;
    @SerializedName(value="bitsPerPixel")
    private Integer bitsPerPixel = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="author")
    private String author = null;
    @SerializedName(value="createdDate")
    private OffsetDateTime createdDate = null;
    @SerializedName(value="modifiedDate")
    private OffsetDateTime modifiedDate = null;
    @SerializedName(value="layers")
    private List<String> layers = null;
    @SerializedName(value="isPasswordProtected")
    private Boolean isPasswordProtected = null;

    public DocumentMetadata fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(value="Document file type")
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public DocumentMetadata pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets pages count if applicable to the current document format")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public DocumentMetadata size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="Document bytes size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public DocumentMetadata width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected width if applicable to the current document format")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public DocumentMetadata height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected height if applicable to the current document format")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public DocumentMetadata horizontalResolution(Integer horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected horizontal resolution if applicable to the current document format")
    public Integer getHorizontalResolution() {
        return this.horizontalResolution;
    }

    public void setHorizontalResolution(Integer horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
    }

    public DocumentMetadata verticalResolution(Integer verticalResolution) {
        this.verticalResolution = verticalResolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected vertical resolution if applicable to the current document format")
    public Integer getVerticalResolution() {
        return this.verticalResolution;
    }

    public void setVerticalResolution(Integer verticalResolution) {
        this.verticalResolution = verticalResolution;
    }

    public DocumentMetadata bitsPerPixel(Integer bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected bits per pixel if applicable to the current document format")
    public Integer getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public void setBitsPerPixel(Integer bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
    }

    public DocumentMetadata title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Returns document title width if applicable to the current document format")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DocumentMetadata author(String author) {
        this.author = author;
        return this;
    }

    @ApiModelProperty(value="Returns detected document author if applicable to the current document format")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public DocumentMetadata createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected document creation date if it's applicable to the current document format")
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public DocumentMetadata modifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Returns detected document modification date if applicable to the current document format")
    public OffsetDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public DocumentMetadata layers(List<String> layers) {
        this.layers = layers;
        return this;
    }

    public DocumentMetadata addLayersItem(String layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        this.layers.add(layersItem);
        return this;
    }

    @ApiModelProperty(value="Returns list of layer names if applicable to the current document format")
    public List<String> getLayers() {
        return this.layers;
    }

    public void setLayers(List<String> layers) {
        this.layers = layers;
    }

    public DocumentMetadata isPasswordProtected(Boolean isPasswordProtected) {
        this.isPasswordProtected = isPasswordProtected;
        return this;
    }

    @ApiModelProperty(required=true, value="Is document password protected")
    public Boolean getIsPasswordProtected() {
        return this.isPasswordProtected;
    }

    public void setIsPasswordProtected(Boolean isPasswordProtected) {
        this.isPasswordProtected = isPasswordProtected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadata documentMetadata = (DocumentMetadata)o;
        return Objects.equals(this.fileType, documentMetadata.fileType) && Objects.equals(this.pageCount, documentMetadata.pageCount) && Objects.equals(this.size, documentMetadata.size) && Objects.equals(this.width, documentMetadata.width) && Objects.equals(this.height, documentMetadata.height) && Objects.equals(this.horizontalResolution, documentMetadata.horizontalResolution) && Objects.equals(this.verticalResolution, documentMetadata.verticalResolution) && Objects.equals(this.bitsPerPixel, documentMetadata.bitsPerPixel) && Objects.equals(this.title, documentMetadata.title) && Objects.equals(this.author, documentMetadata.author) && Objects.equals(this.createdDate, documentMetadata.createdDate) && Objects.equals(this.modifiedDate, documentMetadata.modifiedDate) && Objects.equals(this.layers, documentMetadata.layers) && Objects.equals(this.isPasswordProtected, documentMetadata.isPasswordProtected);
    }

    public int hashCode() {
        return Objects.hash(this.fileType, this.pageCount, this.size, this.width, this.height, this.horizontalResolution, this.verticalResolution, this.bitsPerPixel, this.title, this.author, this.createdDate, this.modifiedDate, this.layers, this.isPasswordProtected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadata {\n");
        sb.append("    fileType: ").append(this.toIndentedString(this.fileType)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    horizontalResolution: ").append(this.toIndentedString(this.horizontalResolution)).append("\n");
        sb.append("    verticalResolution: ").append(this.toIndentedString(this.verticalResolution)).append("\n");
        sb.append("    bitsPerPixel: ").append(this.toIndentedString(this.bitsPerPixel)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    isPasswordProtected: ").append(this.toIndentedString(this.isPasswordProtected)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

