/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Options for to Image conversion")
public class ImageConvertOptions
extends ConvertOptions {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="horizontalResolution")
    private Integer horizontalResolution = null;
    @SerializedName(value="verticalResolution")
    private Integer verticalResolution = null;
    @SerializedName(value="grayscale")
    private Boolean grayscale = null;
    @SerializedName(value="rotateAngle")
    private Integer rotateAngle = null;
    @SerializedName(value="usePdf")
    private Boolean usePdf = null;
    @SerializedName(value="brightness")
    private Integer brightness = null;
    @SerializedName(value="contrast")
    private Integer contrast = null;
    @SerializedName(value="gamma")
    private Double gamma = null;
    @SerializedName(value="flipMode")
    private FlipModeEnum flipMode = null;
    @SerializedName(value="backgroundColor")
    private String backgroundColor = null;

    public ImageConvertOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired image width after conversion")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ImageConvertOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired image height after conversion")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ImageConvertOptions horizontalResolution(Integer horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired image horizontal resolution after conversion. The default resolution is the resolution of the input file or 96dpi")
    public Integer getHorizontalResolution() {
        return this.horizontalResolution;
    }

    public void setHorizontalResolution(Integer horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
    }

    public ImageConvertOptions verticalResolution(Integer verticalResolution) {
        this.verticalResolution = verticalResolution;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired image vertical resolution after conversion. The default resolution is the resolution of the input file or 96dpi")
    public Integer getVerticalResolution() {
        return this.verticalResolution;
    }

    public void setVerticalResolution(Integer verticalResolution) {
        this.verticalResolution = verticalResolution;
    }

    public ImageConvertOptions grayscale(Boolean grayscale) {
        this.grayscale = grayscale;
        return this;
    }

    @ApiModelProperty(required=true, value="Convert to grayscale image")
    public Boolean getGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(Boolean grayscale) {
        this.grayscale = grayscale;
    }

    public ImageConvertOptions rotateAngle(Integer rotateAngle) {
        this.rotateAngle = rotateAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Image rotation angle ")
    public Integer getRotateAngle() {
        return this.rotateAngle;
    }

    public void setRotateAngle(Integer rotateAngle) {
        this.rotateAngle = rotateAngle;
    }

    public ImageConvertOptions usePdf(Boolean usePdf) {
        this.usePdf = usePdf;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, the input firstly is converted to PDF and after that to desired format")
    public Boolean getUsePdf() {
        return this.usePdf;
    }

    public void setUsePdf(Boolean usePdf) {
        this.usePdf = usePdf;
    }

    public ImageConvertOptions brightness(Integer brightness) {
        this.brightness = brightness;
        return this;
    }

    @ApiModelProperty(required=true, value="Adjust image brightness")
    public Integer getBrightness() {
        return this.brightness;
    }

    public void setBrightness(Integer brightness) {
        this.brightness = brightness;
    }

    public ImageConvertOptions contrast(Integer contrast) {
        this.contrast = contrast;
        return this;
    }

    @ApiModelProperty(required=true, value="Adjust image contrast")
    public Integer getContrast() {
        return this.contrast;
    }

    public void setContrast(Integer contrast) {
        this.contrast = contrast;
    }

    public ImageConvertOptions gamma(Double gamma) {
        this.gamma = gamma;
        return this;
    }

    @ApiModelProperty(required=true, value="Adjust image gamma")
    public Double getGamma() {
        return this.gamma;
    }

    public void setGamma(Double gamma) {
        this.gamma = gamma;
    }

    public ImageConvertOptions flipMode(FlipModeEnum flipMode) {
        this.flipMode = flipMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Image flip mode")
    public FlipModeEnum getFlipMode() {
        return this.flipMode;
    }

    public void setFlipMode(FlipModeEnum flipMode) {
        this.flipMode = flipMode;
    }

    public ImageConvertOptions backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a background color.")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageConvertOptions imageConvertOptions = (ImageConvertOptions)o;
        return Objects.equals(this.width, imageConvertOptions.width) && Objects.equals(this.height, imageConvertOptions.height) && Objects.equals(this.horizontalResolution, imageConvertOptions.horizontalResolution) && Objects.equals(this.verticalResolution, imageConvertOptions.verticalResolution) && Objects.equals(this.grayscale, imageConvertOptions.grayscale) && Objects.equals(this.rotateAngle, imageConvertOptions.rotateAngle) && Objects.equals(this.usePdf, imageConvertOptions.usePdf) && Objects.equals(this.brightness, imageConvertOptions.brightness) && Objects.equals(this.contrast, imageConvertOptions.contrast) && Objects.equals(this.gamma, imageConvertOptions.gamma) && Objects.equals((Object)this.flipMode, (Object)imageConvertOptions.flipMode) && Objects.equals(this.backgroundColor, imageConvertOptions.backgroundColor) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.horizontalResolution, this.verticalResolution, this.grayscale, this.rotateAngle, this.usePdf, this.brightness, this.contrast, this.gamma, this.flipMode, this.backgroundColor, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    horizontalResolution: ").append(this.toIndentedString(this.horizontalResolution)).append("\n");
        sb.append("    verticalResolution: ").append(this.toIndentedString(this.verticalResolution)).append("\n");
        sb.append("    grayscale: ").append(this.toIndentedString(this.grayscale)).append("\n");
        sb.append("    rotateAngle: ").append(this.toIndentedString(this.rotateAngle)).append("\n");
        sb.append("    usePdf: ").append(this.toIndentedString(this.usePdf)).append("\n");
        sb.append("    brightness: ").append(this.toIndentedString(this.brightness)).append("\n");
        sb.append("    contrast: ").append(this.toIndentedString(this.contrast)).append("\n");
        sb.append("    gamma: ").append(this.toIndentedString(this.gamma)).append("\n");
        sb.append("    flipMode: ").append(this.toIndentedString((Object)this.flipMode)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FlipModeEnum {
        NONE("None"),
        FLIPX("FlipX"),
        FLIPY("FlipY"),
        FLIPXY("FlipXY");

        private String value;

        private FlipModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FlipModeEnum fromValue(String text) {
            for (FlipModeEnum b : FlipModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FlipModeEnum> {
            public void write(JsonWriter jsonWriter, FlipModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FlipModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FlipModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

