/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Presentation document load options")
public class PresentationLoadOptions
extends LoadOptions {
    @SerializedName(value="preserveDocumentStructure")
    private Boolean preserveDocumentStructure = null;
    @SerializedName(value="clearCustomDocumentProperties")
    private Boolean clearCustomDocumentProperties = null;
    @SerializedName(value="clearBuiltInDocumentProperties")
    private Boolean clearBuiltInDocumentProperties = null;
    @SerializedName(value="depth")
    private Integer depth = null;
    @SerializedName(value="convertOwned")
    private Boolean convertOwned = null;
    @SerializedName(value="convertOwner")
    private Boolean convertOwner = null;
    @SerializedName(value="showHiddenSlides")
    private Boolean showHiddenSlides = null;
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="commentsPosition")
    private CommentsPositionEnum commentsPosition = null;
    @SerializedName(value="notesPosition")
    private NotesPositionEnum notesPosition = null;

    public PresentationLoadOptions preserveDocumentStructure(Boolean preserveDocumentStructure) {
        this.preserveDocumentStructure = preserveDocumentStructure;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the document structure should be preserved when converting     to PDF (default is false).")
    public Boolean getPreserveDocumentStructure() {
        return this.preserveDocumentStructure;
    }

    public void setPreserveDocumentStructure(Boolean preserveDocumentStructure) {
        this.preserveDocumentStructure = preserveDocumentStructure;
    }

    public PresentationLoadOptions clearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Value indicating whether custom document properties should be cleared.")
    public Boolean getClearCustomDocumentProperties() {
        return this.clearCustomDocumentProperties;
    }

    public void setClearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
    }

    public PresentationLoadOptions clearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Value indicating whether built in document properties should be cleared.")
    public Boolean getClearBuiltInDocumentProperties() {
        return this.clearBuiltInDocumentProperties;
    }

    public void setClearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
    }

    public PresentationLoadOptions depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @ApiModelProperty(required=true, value="Implements GroupDocs.Conversion.Contracts.IDocumentsContainerLoadOptions.Depth     Default: 1")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public PresentationLoadOptions convertOwned(Boolean convertOwned) {
        this.convertOwned = convertOwned;
        return this;
    }

    @ApiModelProperty(required=true, value="Implements GroupDocs.Conversion.Contracts.IDocumentsContainerLoadOptions.ConvertOwned     Default is false")
    public Boolean getConvertOwned() {
        return this.convertOwned;
    }

    public void setConvertOwned(Boolean convertOwned) {
        this.convertOwned = convertOwned;
    }

    public PresentationLoadOptions convertOwner(Boolean convertOwner) {
        this.convertOwner = convertOwner;
        return this;
    }

    @ApiModelProperty(required=true, value="Implements GroupDocs.Conversion.Contracts.IDocumentsContainerLoadOptions.ConvertOwner     Default is true")
    public Boolean getConvertOwner() {
        return this.convertOwner;
    }

    public void setConvertOwner(Boolean convertOwner) {
        this.convertOwner = convertOwner;
    }

    public PresentationLoadOptions showHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
        return this;
    }

    @ApiModelProperty(required=true, value="Show hidden slides.")
    public Boolean getShowHiddenSlides() {
        return this.showHiddenSlides;
    }

    public void setShowHiddenSlides(Boolean showHiddenSlides) {
        this.showHiddenSlides = showHiddenSlides;
    }

    public PresentationLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for rendering the presentation. The following font will be used if a presentation font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public PresentationLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public PresentationLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Slides document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public PresentationLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PresentationLoadOptions commentsPosition(CommentsPositionEnum commentsPosition) {
        this.commentsPosition = commentsPosition;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the way comments are printed with the slide. Default is None.")
    public CommentsPositionEnum getCommentsPosition() {
        return this.commentsPosition;
    }

    public void setCommentsPosition(CommentsPositionEnum commentsPosition) {
        this.commentsPosition = commentsPosition;
    }

    public PresentationLoadOptions notesPosition(NotesPositionEnum notesPosition) {
        this.notesPosition = notesPosition;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the way notes are printed with the slide. Default is None.")
    public NotesPositionEnum getNotesPosition() {
        return this.notesPosition;
    }

    public void setNotesPosition(NotesPositionEnum notesPosition) {
        this.notesPosition = notesPosition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentationLoadOptions presentationLoadOptions = (PresentationLoadOptions)o;
        return Objects.equals(this.preserveDocumentStructure, presentationLoadOptions.preserveDocumentStructure) && Objects.equals(this.clearCustomDocumentProperties, presentationLoadOptions.clearCustomDocumentProperties) && Objects.equals(this.clearBuiltInDocumentProperties, presentationLoadOptions.clearBuiltInDocumentProperties) && Objects.equals(this.depth, presentationLoadOptions.depth) && Objects.equals(this.convertOwned, presentationLoadOptions.convertOwned) && Objects.equals(this.convertOwner, presentationLoadOptions.convertOwner) && Objects.equals(this.showHiddenSlides, presentationLoadOptions.showHiddenSlides) && Objects.equals(this.defaultFont, presentationLoadOptions.defaultFont) && Objects.equals(this.fontSubstitutes, presentationLoadOptions.fontSubstitutes) && Objects.equals(this.password, presentationLoadOptions.password) && Objects.equals((Object)this.commentsPosition, (Object)presentationLoadOptions.commentsPosition) && Objects.equals((Object)this.notesPosition, (Object)presentationLoadOptions.notesPosition) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.preserveDocumentStructure, this.clearCustomDocumentProperties, this.clearBuiltInDocumentProperties, this.depth, this.convertOwned, this.convertOwner, this.showHiddenSlides, this.defaultFont, this.fontSubstitutes, this.password, this.commentsPosition, this.notesPosition, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PresentationLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    preserveDocumentStructure: ").append(this.toIndentedString(this.preserveDocumentStructure)).append("\n");
        sb.append("    clearCustomDocumentProperties: ").append(this.toIndentedString(this.clearCustomDocumentProperties)).append("\n");
        sb.append("    clearBuiltInDocumentProperties: ").append(this.toIndentedString(this.clearBuiltInDocumentProperties)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    convertOwned: ").append(this.toIndentedString(this.convertOwned)).append("\n");
        sb.append("    convertOwner: ").append(this.toIndentedString(this.convertOwner)).append("\n");
        sb.append("    showHiddenSlides: ").append(this.toIndentedString(this.showHiddenSlides)).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    commentsPosition: ").append(this.toIndentedString((Object)this.commentsPosition)).append("\n");
        sb.append("    notesPosition: ").append(this.toIndentedString((Object)this.notesPosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NotesPositionEnum {
        NONE("None"),
        BOTTOMTRUNCATED("BottomTruncated"),
        BOTTOMFULL("BottomFull");

        private String value;

        private NotesPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NotesPositionEnum fromValue(String text) {
            for (NotesPositionEnum b : NotesPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NotesPositionEnum> {
            public void write(JsonWriter jsonWriter, NotesPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NotesPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NotesPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommentsPositionEnum {
        NONE("None"),
        BOTTOM("Bottom"),
        RIGHT("Right");

        private String value;

        private CommentsPositionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommentsPositionEnum fromValue(String text) {
            for (CommentsPositionEnum b : CommentsPositionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CommentsPositionEnum> {
            public void write(JsonWriter jsonWriter, CommentsPositionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommentsPositionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommentsPositionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

