/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.ImageConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Psd convert options")
public class PsdConvertOptions
extends ImageConvertOptions {
    @SerializedName(value="channelBitsCount")
    private Integer channelBitsCount = null;
    @SerializedName(value="channelsCount")
    private Integer channelsCount = null;
    @SerializedName(value="colorMode")
    private ColorModeEnum colorMode = null;
    @SerializedName(value="compressionMethod")
    private CompressionMethodEnum compressionMethod = null;
    @SerializedName(value="version")
    private Integer version = null;

    public PsdConvertOptions channelBitsCount(Integer channelBitsCount) {
        this.channelBitsCount = channelBitsCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Bits count per color channel")
    public Integer getChannelBitsCount() {
        return this.channelBitsCount;
    }

    public void setChannelBitsCount(Integer channelBitsCount) {
        this.channelBitsCount = channelBitsCount;
    }

    public PsdConvertOptions channelsCount(Integer channelsCount) {
        this.channelsCount = channelsCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Color channels count")
    public Integer getChannelsCount() {
        return this.channelsCount;
    }

    public void setChannelsCount(Integer channelsCount) {
        this.channelsCount = channelsCount;
    }

    public PsdConvertOptions colorMode(ColorModeEnum colorMode) {
        this.colorMode = colorMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Psd color mode")
    public ColorModeEnum getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(ColorModeEnum colorMode) {
        this.colorMode = colorMode;
    }

    public PsdConvertOptions compressionMethod(CompressionMethodEnum compressionMethod) {
        this.compressionMethod = compressionMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="Psd compression method")
    public CompressionMethodEnum getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethodEnum compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public PsdConvertOptions version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Psd file version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsdConvertOptions psdConvertOptions = (PsdConvertOptions)o;
        return Objects.equals(this.channelBitsCount, psdConvertOptions.channelBitsCount) && Objects.equals(this.channelsCount, psdConvertOptions.channelsCount) && Objects.equals((Object)this.colorMode, (Object)psdConvertOptions.colorMode) && Objects.equals((Object)this.compressionMethod, (Object)psdConvertOptions.compressionMethod) && Objects.equals(this.version, psdConvertOptions.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.channelBitsCount, this.channelsCount, this.colorMode, this.compressionMethod, this.version, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PsdConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    channelBitsCount: ").append(this.toIndentedString(this.channelBitsCount)).append("\n");
        sb.append("    channelsCount: ").append(this.toIndentedString(this.channelsCount)).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.colorMode)).append("\n");
        sb.append("    compressionMethod: ").append(this.toIndentedString((Object)this.compressionMethod)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CompressionMethodEnum {
        RAW("Raw"),
        RLE("Rle"),
        ZIPWITHOUTPREDICTION("ZipWithoutPrediction"),
        ZIPWITHPREDICTION("ZipWithPrediction");

        private String value;

        private CompressionMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CompressionMethodEnum fromValue(String text) {
            for (CompressionMethodEnum b : CompressionMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CompressionMethodEnum> {
            public void write(JsonWriter jsonWriter, CompressionMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CompressionMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CompressionMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ColorModeEnum {
        BITMAP("Bitmap"),
        GRAYSCALE("Grayscale"),
        INDEXED("Indexed"),
        RGB("Rgb"),
        CMYK("Cmyk"),
        MULTICHANNEL("Multichannel"),
        DUOTONE("Duotone"),
        LAB("Lab");

        private String value;

        private ColorModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ColorModeEnum fromValue(String text) {
            for (ColorModeEnum b : ColorModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ColorModeEnum> {
            public void write(JsonWriter jsonWriter, ColorModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ColorModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ColorModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

