/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Options for settings watermark to the converted document")
public class WatermarkOptions {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="fontName")
    private String fontName = null;
    @SerializedName(value="fontSize")
    private Integer fontSize = null;
    @SerializedName(value="bold")
    private Boolean bold = null;
    @SerializedName(value="italic")
    private Boolean italic = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="top")
    private Integer top = null;
    @SerializedName(value="left")
    private Integer left = null;
    @SerializedName(value="rotationAngle")
    private Integer rotationAngle = null;
    @SerializedName(value="transparency")
    private Double transparency = null;
    @SerializedName(value="background")
    private Boolean background = null;
    @SerializedName(value="image")
    private String image = null;
    @SerializedName(value="autoAlign")
    private Boolean autoAlign = null;

    public WatermarkOptions text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(value="Watermark text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WatermarkOptions fontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    @ApiModelProperty(value="Watermark font name if text watermark is applied")
    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public WatermarkOptions fontSize(Integer fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark font name if text watermark is applied")
    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public WatermarkOptions bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark font bold style if text watermark is applied")
    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public WatermarkOptions italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark font italic style if text watermark is applied")
    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public WatermarkOptions color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="Watermark font color if text watermark is applied")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public WatermarkOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark width")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public WatermarkOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark height")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public WatermarkOptions top(Integer top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark top position")
    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public WatermarkOptions left(Integer left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark left position")
    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(Integer left) {
        this.left = left;
    }

    public WatermarkOptions rotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark rotation angle")
    public Integer getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(Integer rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public WatermarkOptions transparency(Double transparency) {
        this.transparency = transparency;
        return this;
    }

    @ApiModelProperty(required=true, value="Watermark transparency. Value between 0 and 1. Value 0 is fully visible, value 1 is invisible.")
    public Double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Double transparency) {
        this.transparency = transparency;
    }

    public WatermarkOptions background(Boolean background) {
        this.background = background;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates that the watermark is stamped as background. If the value is true, the watermark is layed at the bottom. By default is false and the watermark is layed on top.")
    public Boolean getBackground() {
        return this.background;
    }

    public void setBackground(Boolean background) {
        this.background = background;
    }

    public WatermarkOptions image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="Image watermark")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public WatermarkOptions autoAlign(Boolean autoAlign) {
        this.autoAlign = autoAlign;
        return this;
    }

    @ApiModelProperty(required=true, value="Auto scale the watermark. If the value is true the font size and the position is automatically calculated to fit the page size.")
    public Boolean getAutoAlign() {
        return this.autoAlign;
    }

    public void setAutoAlign(Boolean autoAlign) {
        this.autoAlign = autoAlign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkOptions watermarkOptions = (WatermarkOptions)o;
        return Objects.equals(this.text, watermarkOptions.text) && Objects.equals(this.fontName, watermarkOptions.fontName) && Objects.equals(this.fontSize, watermarkOptions.fontSize) && Objects.equals(this.bold, watermarkOptions.bold) && Objects.equals(this.italic, watermarkOptions.italic) && Objects.equals(this.color, watermarkOptions.color) && Objects.equals(this.width, watermarkOptions.width) && Objects.equals(this.height, watermarkOptions.height) && Objects.equals(this.top, watermarkOptions.top) && Objects.equals(this.left, watermarkOptions.left) && Objects.equals(this.rotationAngle, watermarkOptions.rotationAngle) && Objects.equals(this.transparency, watermarkOptions.transparency) && Objects.equals(this.background, watermarkOptions.background) && Objects.equals(this.image, watermarkOptions.image) && Objects.equals(this.autoAlign, watermarkOptions.autoAlign);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.fontName, this.fontSize, this.bold, this.italic, this.color, this.width, this.height, this.top, this.left, this.rotationAngle, this.transparency, this.background, this.image, this.autoAlign);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatermarkOptions {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    fontName: ").append(this.toIndentedString(this.fontName)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    rotationAngle: ").append(this.toIndentedString(this.rotationAngle)).append("\n");
        sb.append("    transparency: ").append(this.toIndentedString(this.transparency)).append("\n");
        sb.append("    background: ").append(this.toIndentedString(this.background)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    autoAlign: ").append(this.toIndentedString(this.autoAlign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

