/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.conversion.client.ApiCallback;
import com.groupdocs.cloud.conversion.client.ApiClient;
import com.groupdocs.cloud.conversion.client.ApiException;
import com.groupdocs.cloud.conversion.client.ApiResponse;
import com.groupdocs.cloud.conversion.client.Configuration;
import com.groupdocs.cloud.conversion.client.Pair;
import com.groupdocs.cloud.conversion.client.ProgressRequestBody;
import com.groupdocs.cloud.conversion.client.ProgressResponseBody;
import com.groupdocs.cloud.conversion.model.ConvertSettings;
import com.groupdocs.cloud.conversion.model.StoredConvertedResult;
import com.groupdocs.cloud.conversion.model.requests.ConvertDocumentDirectRequest;
import com.groupdocs.cloud.conversion.model.requests.ConvertDocumentRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConvertApi {
    private ApiClient apiClient;

    public ConvertApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public ConvertApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call convertDocumentCall(ConvertDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ConvertSettings localVarPostBody = request.getconvertSettings();
        String localVarPath = "/conversion";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertDocumentValidateBeforeCall(ConvertDocumentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getconvertSettings() == null) {
            throw new ApiException("Missing the required parameter 'convertSettings' when calling convertDocument(Async)");
        }
        Call call = this.convertDocumentCall(request, progressListener, progressRequestListener);
        return call;
    }

    public List<StoredConvertedResult> convertDocument(ConvertDocumentRequest request) throws ApiException {
        ApiResponse<List<StoredConvertedResult>> resp = this.convertDocumentWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<List<StoredConvertedResult>> convertDocumentWithHttpInfo(ConvertDocumentRequest request) throws ApiException {
        Call call = this.convertDocumentValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<List<StoredConvertedResult>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertDocumentAsync(ConvertDocumentRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertDocumentValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call convertDocumentDownloadCall(ConvertDocumentRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ConvertSettings localVarPostBody = request.getconvertSettings();
        String localVarPath = "/conversion";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertDocumentDownloadValidateBeforeCall(ConvertDocumentRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getconvertSettings() == null) {
            throw new ApiException("Missing the required parameter 'convertSettings' when calling convertDocument(Async)");
        }
        Call call = this.convertDocumentDownloadCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File convertDocumentDownload(ConvertDocumentRequest request) throws ApiException {
        ApiResponse<File> resp = this.convertDocumentDownloadWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> convertDocumentDownloadWithHttpInfo(ConvertDocumentRequest request) throws ApiException {
        Call call = this.convertDocumentDownloadValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertDocumentDownloadAsync(ConvertDocumentRequest request, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertDocumentDownloadValidateBeforeCall(request, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call convertDocumentDirectCall(ConvertDocumentDirectRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/conversion";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (request.getformat() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("format", request.getformat()));
        }
        if (request.getfromPage() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fromPage", request.getfromPage()));
        }
        if (request.getpagesCount() != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pagesCount", request.getpagesCount()));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (request.getFile() != null) {
            localVarFormParams.put("File", request.getFile());
        }
        if (request.getloadOptions() != null) {
            localVarFormParams.put("loadOptions", request.getloadOptions());
        }
        if (request.getconvertOptions() != null) {
            localVarFormParams.put("convertOptions", request.getconvertOptions());
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertDocumentDirectValidateBeforeCall(ConvertDocumentDirectRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getformat() == null) {
            throw new ApiException("Missing the required parameter 'format' when calling convertDocumentDirect(Async)");
        }
        if (request.getFile() == null) {
            throw new ApiException("Missing the required parameter 'file' when calling convertDocumentDirect(Async)");
        }
        Call call = this.convertDocumentDirectCall(request, progressListener, progressRequestListener);
        return call;
    }

    public File convertDocumentDirect(ConvertDocumentDirectRequest request) throws ApiException {
        ApiResponse<File> resp = this.convertDocumentDirectWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<File> convertDocumentDirectWithHttpInfo(ConvertDocumentDirectRequest request) throws ApiException {
        Call call = this.convertDocumentDirectValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertDocumentDirectAsync(ConvertDocumentDirectRequest request, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertDocumentDirectValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

