/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.conversion.client.ApiCallback;
import com.groupdocs.cloud.conversion.client.ApiClient;
import com.groupdocs.cloud.conversion.client.ApiException;
import com.groupdocs.cloud.conversion.client.ApiResponse;
import com.groupdocs.cloud.conversion.client.Configuration;
import com.groupdocs.cloud.conversion.client.Pair;
import com.groupdocs.cloud.conversion.client.ProgressRequestBody;
import com.groupdocs.cloud.conversion.client.ProgressResponseBody;
import com.groupdocs.cloud.conversion.model.ConsumptionResult;
import com.groupdocs.cloud.conversion.model.LicenseInfo;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class LicenseApi {
    private ApiClient apiClient;

    public LicenseApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public LicenseApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getConsumptionCreditCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/consumption";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getConsumptionCreditValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getConsumptionCreditCall(progressListener, progressRequestListener);
        return call;
    }

    public ConsumptionResult getConsumptionCredit() throws ApiException {
        ApiResponse<ConsumptionResult> resp = this.getConsumptionCreditWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ConsumptionResult> getConsumptionCreditWithHttpInfo() throws ApiException {
        Call call = this.getConsumptionCreditValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ConsumptionResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getConsumptionCreditAsync(final ApiCallback<ConsumptionResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getConsumptionCreditValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ConsumptionResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLicenseInfoCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/conversion/license";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLicenseInfoValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getLicenseInfoCall(progressListener, progressRequestListener);
        return call;
    }

    public LicenseInfo getLicenseInfo() throws ApiException {
        ApiResponse<LicenseInfo> resp = this.getLicenseInfoWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<LicenseInfo> getLicenseInfoWithHttpInfo() throws ApiException {
        Call call = this.getLicenseInfoValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<LicenseInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLicenseInfoAsync(final ApiCallback<LicenseInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLicenseInfoValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LicenseInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

