/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Ebook convert options")
public class EBookConvertOptions
extends ConvertOptions {
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="pageOrientation")
    private PageOrientationEnum pageOrientation = null;

    public EBookConvertOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies page size")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public EBookConvertOptions pageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies page orientation")
    public PageOrientationEnum getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EBookConvertOptions ebookConvertOptions = (EBookConvertOptions)o;
        return Objects.equals((Object)this.pageSize, (Object)ebookConvertOptions.pageSize) && Objects.equals((Object)this.pageOrientation, (Object)ebookConvertOptions.pageOrientation) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.pageOrientation, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EBookConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    pageOrientation: ").append(this.toIndentedString((Object)this.pageOrientation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageOrientationEnum {
        DEFAULT("Default"),
        LANDSCAPE("Landscape"),
        PORTRAIT("Portrait");

        private String value;

        private PageOrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageOrientationEnum fromValue(String text) {
            for (PageOrientationEnum b : PageOrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageOrientationEnum> {
            public void write(JsonWriter jsonWriter, PageOrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageOrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageOrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        DEFAULT("Default"),
        A3("A3"),
        STATEMENT("Statement"),
        QUARTO("Quarto"),
        PAPER11X17("Paper11x17"),
        PAPER10X14("Paper10x14"),
        LETTER("Letter"),
        LEGAL("Legal"),
        LEDGER("Ledger"),
        FOLIO("Folio"),
        EXECUTIVE("Executive"),
        ENVELOPEDL("EnvelopeDL"),
        CUSTOM("Custom"),
        B5("B5"),
        B4("B4"),
        A5("A5"),
        A4("A4"),
        TABLOID("Tabloid");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

