/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.StoredConvertedResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Operation status result")
public class OperationResult {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="method")
    private MethodEnum method = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="created")
    private OffsetDateTime created = null;
    @SerializedName(value="started")
    private OffsetDateTime started = null;
    @SerializedName(value="failed")
    private OffsetDateTime failed = null;
    @SerializedName(value="canceled")
    private OffsetDateTime canceled = null;
    @SerializedName(value="finished")
    private OffsetDateTime finished = null;
    @SerializedName(value="result")
    private List<StoredConvertedResult> result = null;
    @SerializedName(value="error")
    private String error = null;

    public OperationResult id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OperationResult method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public OperationResult status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OperationResult created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public OperationResult started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getStarted() {
        return this.started;
    }

    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public OperationResult failed(OffsetDateTime failed) {
        this.failed = failed;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFailed() {
        return this.failed;
    }

    public void setFailed(OffsetDateTime failed) {
        this.failed = failed;
    }

    public OperationResult canceled(OffsetDateTime canceled) {
        this.canceled = canceled;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCanceled() {
        return this.canceled;
    }

    public void setCanceled(OffsetDateTime canceled) {
        this.canceled = canceled;
    }

    public OperationResult finished(OffsetDateTime finished) {
        this.finished = finished;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFinished() {
        return this.finished;
    }

    public void setFinished(OffsetDateTime finished) {
        this.finished = finished;
    }

    public OperationResult result(List<StoredConvertedResult> result) {
        this.result = result;
        return this;
    }

    public OperationResult addResultItem(StoredConvertedResult resultItem) {
        if (this.result == null) {
            this.result = new ArrayList<StoredConvertedResult>();
        }
        this.result.add(resultItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<StoredConvertedResult> getResult() {
        return this.result;
    }

    public void setResult(List<StoredConvertedResult> result) {
        this.result = result;
    }

    public OperationResult error(String error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationResult operationResult = (OperationResult)o;
        return Objects.equals(this.id, operationResult.id) && Objects.equals((Object)this.method, (Object)operationResult.method) && Objects.equals((Object)this.status, (Object)operationResult.status) && Objects.equals(this.created, operationResult.created) && Objects.equals(this.started, operationResult.started) && Objects.equals(this.failed, operationResult.failed) && Objects.equals(this.canceled, operationResult.canceled) && Objects.equals(this.finished, operationResult.finished) && Objects.equals(this.result, operationResult.result) && Objects.equals(this.error, operationResult.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.method, this.status, this.created, this.started, this.failed, this.canceled, this.finished, this.result, this.error});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationResult {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    canceled: ").append(this.toIndentedString(this.canceled)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CREATED("Created"),
        STARTED("Started"),
        FAILED("Failed"),
        CANCELED("Canceled"),
        FINISHED("Finished");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        CONVERT("Convert"),
        CONVERTANDSAVE("ConvertAndSave");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String text) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

