/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Options for to PDF conversion")
public class PdfConvertOptions
extends ConvertOptions {
    @SerializedName(value="width")
    private Integer width = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="dpi")
    private Integer dpi = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="marginTop")
    private Integer marginTop = null;
    @SerializedName(value="marginBottom")
    private Integer marginBottom = null;
    @SerializedName(value="marginLeft")
    private Integer marginLeft = null;
    @SerializedName(value="marginRight")
    private Integer marginRight = null;
    @SerializedName(value="pdfFormat")
    private PdfFormatEnum pdfFormat = null;
    @SerializedName(value="removePdfaCompliance")
    private Boolean removePdfaCompliance = null;
    @SerializedName(value="zoom")
    private Integer zoom = null;
    @SerializedName(value="linearize")
    private Boolean linearize = null;
    @SerializedName(value="linkDuplicateStreams")
    private Boolean linkDuplicateStreams = null;
    @SerializedName(value="removeUnusedObjects")
    private Boolean removeUnusedObjects = null;
    @SerializedName(value="removeUnusedStreams")
    private Boolean removeUnusedStreams = null;
    @SerializedName(value="compressImages")
    private Boolean compressImages = null;
    @SerializedName(value="imageQuality")
    private Integer imageQuality = null;
    @SerializedName(value="unembedFonts")
    private Boolean unembedFonts = null;
    @SerializedName(value="grayscale")
    private Boolean grayscale = null;
    @SerializedName(value="centerWindow")
    private Boolean centerWindow = null;
    @SerializedName(value="direction")
    private DirectionEnum direction = null;
    @SerializedName(value="displayDocTitle")
    private Boolean displayDocTitle = null;
    @SerializedName(value="fitWindow")
    private Boolean fitWindow = null;
    @SerializedName(value="hideMenuBar")
    private Boolean hideMenuBar = null;
    @SerializedName(value="hideToolBar")
    private Boolean hideToolBar = null;
    @SerializedName(value="hideWindowUI")
    private Boolean hideWindowUI = null;
    @SerializedName(value="nonFullScreenPageMode")
    private NonFullScreenPageModeEnum nonFullScreenPageMode = null;
    @SerializedName(value="pageLayout")
    private PageLayoutEnum pageLayout = null;
    @SerializedName(value="pageMode")
    private PageModeEnum pageMode = null;
    @SerializedName(value="rotate")
    private RotateEnum rotate = null;
    @SerializedName(value="pageSize")
    private PageSizeEnum pageSize = null;
    @SerializedName(value="pageOrientation")
    private PageOrientationEnum pageOrientation = null;

    public PdfConvertOptions width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page width in pixels after conversion")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public PdfConvertOptions height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page height in pixels after conversion")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public PdfConvertOptions dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page DPI after conversion. The default resolution is: 96dpi")
    public Integer getDpi() {
        return this.dpi;
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public PdfConvertOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set this property if you want to protect the converted document with a password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PdfConvertOptions marginTop(Integer marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page top margin in pixels after conversion")
    public Integer getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(Integer marginTop) {
        this.marginTop = marginTop;
    }

    public PdfConvertOptions marginBottom(Integer marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page bottom margin in pixels after conversion")
    public Integer getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(Integer marginBottom) {
        this.marginBottom = marginBottom;
    }

    public PdfConvertOptions marginLeft(Integer marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page left margin in pixels after conversion")
    public Integer getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(Integer marginLeft) {
        this.marginLeft = marginLeft;
    }

    public PdfConvertOptions marginRight(Integer marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    @ApiModelProperty(required=true, value="Desired page right margin in pixels after conversion")
    public Integer getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(Integer marginRight) {
        this.marginRight = marginRight;
    }

    public PdfConvertOptions pdfFormat(PdfFormatEnum pdfFormat) {
        this.pdfFormat = pdfFormat;
        return this;
    }

    @ApiModelProperty(required=true, value="Set the pdf format of the converted document.")
    public PdfFormatEnum getPdfFormat() {
        return this.pdfFormat;
    }

    public void setPdfFormat(PdfFormatEnum pdfFormat) {
        this.pdfFormat = pdfFormat;
    }

    public PdfConvertOptions removePdfaCompliance(Boolean removePdfaCompliance) {
        this.removePdfaCompliance = removePdfaCompliance;
        return this;
    }

    @ApiModelProperty(required=true, value="Remove Pdf-A Compliance")
    public Boolean getRemovePdfaCompliance() {
        return this.removePdfaCompliance;
    }

    public void setRemovePdfaCompliance(Boolean removePdfaCompliance) {
        this.removePdfaCompliance = removePdfaCompliance;
    }

    public PdfConvertOptions zoom(Integer zoom) {
        this.zoom = zoom;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the zoom level in percentage. Default is 100.")
    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public PdfConvertOptions linearize(Boolean linearize) {
        this.linearize = linearize;
        return this;
    }

    @ApiModelProperty(required=true, value="Linearize PDF Document for the Web")
    public Boolean getLinearize() {
        return this.linearize;
    }

    public void setLinearize(Boolean linearize) {
        this.linearize = linearize;
    }

    public PdfConvertOptions linkDuplicateStreams(Boolean linkDuplicateStreams) {
        this.linkDuplicateStreams = linkDuplicateStreams;
        return this;
    }

    @ApiModelProperty(required=true, value="Link duplicate streams")
    public Boolean getLinkDuplicateStreams() {
        return this.linkDuplicateStreams;
    }

    public void setLinkDuplicateStreams(Boolean linkDuplicateStreams) {
        this.linkDuplicateStreams = linkDuplicateStreams;
    }

    public PdfConvertOptions removeUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
        return this;
    }

    @ApiModelProperty(required=true, value="Remove unused objects")
    public Boolean getRemoveUnusedObjects() {
        return this.removeUnusedObjects;
    }

    public void setRemoveUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
    }

    public PdfConvertOptions removeUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
        return this;
    }

    @ApiModelProperty(required=true, value="Remove unused streams")
    public Boolean getRemoveUnusedStreams() {
        return this.removeUnusedStreams;
    }

    public void setRemoveUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
    }

    public PdfConvertOptions compressImages(Boolean compressImages) {
        this.compressImages = compressImages;
        return this;
    }

    @ApiModelProperty(required=true, value="If CompressImages set to true, all images in the document are recompressed. The compression is defined by the ImageQuality property.")
    public Boolean getCompressImages() {
        return this.compressImages;
    }

    public void setCompressImages(Boolean compressImages) {
        this.compressImages = compressImages;
    }

    public PdfConvertOptions imageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="Value in percent where 100% is unchanged quality and image size. To decrease the image size, use ImageQuality less than 100             ")
    public Integer getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
    }

    public PdfConvertOptions unembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
        return this;
    }

    @ApiModelProperty(required=true, value="Make fonts not embedded if set to true")
    public Boolean getUnembedFonts() {
        return this.unembedFonts;
    }

    public void setUnembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
    }

    public PdfConvertOptions grayscale(Boolean grayscale) {
        this.grayscale = grayscale;
        return this;
    }

    @ApiModelProperty(required=true, value="Convert a PDF from RGB colorspace to Grayscale")
    public Boolean getGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(Boolean grayscale) {
        this.grayscale = grayscale;
    }

    public PdfConvertOptions centerWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
        return this;
    }

    @ApiModelProperty(required=true, value="Specify whether position of the document's window will be centered on the screen. Default: false.")
    public Boolean getCenterWindow() {
        return this.centerWindow;
    }

    public void setCenterWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
    }

    public PdfConvertOptions direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets reading order of text: L2R (left to right) or R2L (right to left). Default: L2R.")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public PdfConvertOptions displayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifying whether document's window title bar should display document title. Default: false.")
    public Boolean getDisplayDocTitle() {
        return this.displayDocTitle;
    }

    public void setDisplayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
    }

    public PdfConvertOptions fitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
        return this;
    }

    @ApiModelProperty(required=true, value="Specify whether document window must be resized to fit the first displayed page. Default: false.")
    public Boolean getFitWindow() {
        return this.fitWindow;
    }

    public void setFitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
    }

    public PdfConvertOptions hideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
        return this;
    }

    @ApiModelProperty(required=true, value="Specify whether menu bar should be hidden when document is active. Default: false.")
    public Boolean getHideMenuBar() {
        return this.hideMenuBar;
    }

    public void setHideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
    }

    public PdfConvertOptions hideToolBar(Boolean hideToolBar) {
        this.hideToolBar = hideToolBar;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifying whether toolbar should be hidden when document is active. Default: false.")
    public Boolean getHideToolBar() {
        return this.hideToolBar;
    }

    public void setHideToolBar(Boolean hideToolBar) {
        this.hideToolBar = hideToolBar;
    }

    public PdfConvertOptions hideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
        return this;
    }

    @ApiModelProperty(required=true, value="Specify whether user interface elements should be hidden when document is active. Default: false.")
    public Boolean getHideWindowUI() {
        return this.hideWindowUI;
    }

    public void setHideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
    }

    public PdfConvertOptions nonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets page mode, specifying how to display the document on exiting full-screen mode.")
    public NonFullScreenPageModeEnum getNonFullScreenPageMode() {
        return this.nonFullScreenPageMode;
    }

    public void setNonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
    }

    public PdfConvertOptions pageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets page layout which shall be used when the document is opened.")
    public PageLayoutEnum getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
    }

    public PdfConvertOptions pageMode(PageModeEnum pageMode) {
        this.pageMode = pageMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Sets page mode, specifying how document should be displayed when opened.")
    public PageModeEnum getPageMode() {
        return this.pageMode;
    }

    public void setPageMode(PageModeEnum pageMode) {
        this.pageMode = pageMode;
    }

    public PdfConvertOptions rotate(RotateEnum rotate) {
        this.rotate = rotate;
        return this;
    }

    @ApiModelProperty(required=true, value="Rotate page")
    public RotateEnum getRotate() {
        return this.rotate;
    }

    public void setRotate(RotateEnum rotate) {
        this.rotate = rotate;
    }

    public PdfConvertOptions pageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies page size")
    public PageSizeEnum getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSizeEnum pageSize) {
        this.pageSize = pageSize;
    }

    public PdfConvertOptions pageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies page orientation")
    public PageOrientationEnum getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(PageOrientationEnum pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfConvertOptions pdfConvertOptions = (PdfConvertOptions)o;
        return Objects.equals(this.width, pdfConvertOptions.width) && Objects.equals(this.height, pdfConvertOptions.height) && Objects.equals(this.dpi, pdfConvertOptions.dpi) && Objects.equals(this.password, pdfConvertOptions.password) && Objects.equals(this.marginTop, pdfConvertOptions.marginTop) && Objects.equals(this.marginBottom, pdfConvertOptions.marginBottom) && Objects.equals(this.marginLeft, pdfConvertOptions.marginLeft) && Objects.equals(this.marginRight, pdfConvertOptions.marginRight) && Objects.equals((Object)this.pdfFormat, (Object)pdfConvertOptions.pdfFormat) && Objects.equals(this.removePdfaCompliance, pdfConvertOptions.removePdfaCompliance) && Objects.equals(this.zoom, pdfConvertOptions.zoom) && Objects.equals(this.linearize, pdfConvertOptions.linearize) && Objects.equals(this.linkDuplicateStreams, pdfConvertOptions.linkDuplicateStreams) && Objects.equals(this.removeUnusedObjects, pdfConvertOptions.removeUnusedObjects) && Objects.equals(this.removeUnusedStreams, pdfConvertOptions.removeUnusedStreams) && Objects.equals(this.compressImages, pdfConvertOptions.compressImages) && Objects.equals(this.imageQuality, pdfConvertOptions.imageQuality) && Objects.equals(this.unembedFonts, pdfConvertOptions.unembedFonts) && Objects.equals(this.grayscale, pdfConvertOptions.grayscale) && Objects.equals(this.centerWindow, pdfConvertOptions.centerWindow) && Objects.equals((Object)this.direction, (Object)pdfConvertOptions.direction) && Objects.equals(this.displayDocTitle, pdfConvertOptions.displayDocTitle) && Objects.equals(this.fitWindow, pdfConvertOptions.fitWindow) && Objects.equals(this.hideMenuBar, pdfConvertOptions.hideMenuBar) && Objects.equals(this.hideToolBar, pdfConvertOptions.hideToolBar) && Objects.equals(this.hideWindowUI, pdfConvertOptions.hideWindowUI) && Objects.equals((Object)this.nonFullScreenPageMode, (Object)pdfConvertOptions.nonFullScreenPageMode) && Objects.equals((Object)this.pageLayout, (Object)pdfConvertOptions.pageLayout) && Objects.equals((Object)this.pageMode, (Object)pdfConvertOptions.pageMode) && Objects.equals((Object)this.rotate, (Object)pdfConvertOptions.rotate) && Objects.equals((Object)this.pageSize, (Object)pdfConvertOptions.pageSize) && Objects.equals((Object)this.pageOrientation, (Object)pdfConvertOptions.pageOrientation) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.width, this.height, this.dpi, this.password, this.marginTop, this.marginBottom, this.marginLeft, this.marginRight, this.pdfFormat, this.removePdfaCompliance, this.zoom, this.linearize, this.linkDuplicateStreams, this.removeUnusedObjects, this.removeUnusedStreams, this.compressImages, this.imageQuality, this.unembedFonts, this.grayscale, this.centerWindow, this.direction, this.displayDocTitle, this.fitWindow, this.hideMenuBar, this.hideToolBar, this.hideWindowUI, this.nonFullScreenPageMode, this.pageLayout, this.pageMode, this.rotate, this.pageSize, this.pageOrientation, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfConvertOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    marginTop: ").append(this.toIndentedString(this.marginTop)).append("\n");
        sb.append("    marginBottom: ").append(this.toIndentedString(this.marginBottom)).append("\n");
        sb.append("    marginLeft: ").append(this.toIndentedString(this.marginLeft)).append("\n");
        sb.append("    marginRight: ").append(this.toIndentedString(this.marginRight)).append("\n");
        sb.append("    pdfFormat: ").append(this.toIndentedString((Object)this.pdfFormat)).append("\n");
        sb.append("    removePdfaCompliance: ").append(this.toIndentedString(this.removePdfaCompliance)).append("\n");
        sb.append("    zoom: ").append(this.toIndentedString(this.zoom)).append("\n");
        sb.append("    linearize: ").append(this.toIndentedString(this.linearize)).append("\n");
        sb.append("    linkDuplicateStreams: ").append(this.toIndentedString(this.linkDuplicateStreams)).append("\n");
        sb.append("    removeUnusedObjects: ").append(this.toIndentedString(this.removeUnusedObjects)).append("\n");
        sb.append("    removeUnusedStreams: ").append(this.toIndentedString(this.removeUnusedStreams)).append("\n");
        sb.append("    compressImages: ").append(this.toIndentedString(this.compressImages)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString(this.imageQuality)).append("\n");
        sb.append("    unembedFonts: ").append(this.toIndentedString(this.unembedFonts)).append("\n");
        sb.append("    grayscale: ").append(this.toIndentedString(this.grayscale)).append("\n");
        sb.append("    centerWindow: ").append(this.toIndentedString(this.centerWindow)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    displayDocTitle: ").append(this.toIndentedString(this.displayDocTitle)).append("\n");
        sb.append("    fitWindow: ").append(this.toIndentedString(this.fitWindow)).append("\n");
        sb.append("    hideMenuBar: ").append(this.toIndentedString(this.hideMenuBar)).append("\n");
        sb.append("    hideToolBar: ").append(this.toIndentedString(this.hideToolBar)).append("\n");
        sb.append("    hideWindowUI: ").append(this.toIndentedString(this.hideWindowUI)).append("\n");
        sb.append("    nonFullScreenPageMode: ").append(this.toIndentedString((Object)this.nonFullScreenPageMode)).append("\n");
        sb.append("    pageLayout: ").append(this.toIndentedString((Object)this.pageLayout)).append("\n");
        sb.append("    pageMode: ").append(this.toIndentedString((Object)this.pageMode)).append("\n");
        sb.append("    rotate: ").append(this.toIndentedString((Object)this.rotate)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString((Object)this.pageSize)).append("\n");
        sb.append("    pageOrientation: ").append(this.toIndentedString((Object)this.pageOrientation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageOrientationEnum {
        DEFAULT("Default"),
        LANDSCAPE("Landscape"),
        PORTRAIT("Portrait");

        private String value;

        private PageOrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageOrientationEnum fromValue(String text) {
            for (PageOrientationEnum b : PageOrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageOrientationEnum> {
            public void write(JsonWriter jsonWriter, PageOrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageOrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageOrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageSizeEnum {
        DEFAULT("Default"),
        A3("A3"),
        STATEMENT("Statement"),
        QUARTO("Quarto"),
        PAPER11X17("Paper11x17"),
        PAPER10X14("Paper10x14"),
        LETTER("Letter"),
        LEGAL("Legal"),
        LEDGER("Ledger"),
        FOLIO("Folio"),
        EXECUTIVE("Executive"),
        ENVELOPEDL("EnvelopeDL"),
        CUSTOM("Custom"),
        B5("B5"),
        B4("B4"),
        A5("A5"),
        A4("A4"),
        TABLOID("Tabloid");

        private String value;

        private PageSizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageSizeEnum fromValue(String text) {
            for (PageSizeEnum b : PageSizeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageSizeEnum> {
            public void write(JsonWriter jsonWriter, PageSizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageSizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageSizeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RotateEnum {
        NONE("None"),
        ON90("On90"),
        ON180("On180"),
        ON270("On270");

        private String value;

        private RotateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RotateEnum fromValue(String text) {
            for (RotateEnum b : RotateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RotateEnum> {
            public void write(JsonWriter jsonWriter, RotateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RotateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RotateEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageModeEnum {
        USENONE("UseNone"),
        USEOUTLINES("UseOutlines"),
        USETHUMBS("UseThumbs"),
        FULLSCREEN("FullScreen"),
        USEOC("UseOC"),
        USEATTACHMENTS("UseAttachments");

        private String value;

        private PageModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageModeEnum fromValue(String text) {
            for (PageModeEnum b : PageModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageModeEnum> {
            public void write(JsonWriter jsonWriter, PageModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageLayoutEnum {
        DEFAULT("Default"),
        SINGLEPAGE("SinglePage"),
        ONECOLUMN("OneColumn"),
        TWOCOLUMNLEFT("TwoColumnLeft"),
        TWOCOLUMNRIGHT("TwoColumnRight"),
        TWOPAGELEFT("TwoPageLeft"),
        TWOPAGERIGHT("TwoPageRight");

        private String value;

        private PageLayoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageLayoutEnum fromValue(String text) {
            for (PageLayoutEnum b : PageLayoutEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageLayoutEnum> {
            public void write(JsonWriter jsonWriter, PageLayoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageLayoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageLayoutEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NonFullScreenPageModeEnum {
        USENONE("UseNone"),
        USEOUTLINES("UseOutlines"),
        USETHUMBS("UseThumbs"),
        FULLSCREEN("FullScreen"),
        USEOC("UseOC"),
        USEATTACHMENTS("UseAttachments");

        private String value;

        private NonFullScreenPageModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NonFullScreenPageModeEnum fromValue(String text) {
            for (NonFullScreenPageModeEnum b : NonFullScreenPageModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<NonFullScreenPageModeEnum> {
            public void write(JsonWriter jsonWriter, NonFullScreenPageModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NonFullScreenPageModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NonFullScreenPageModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        L2R("L2R"),
        R2L("R2L");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String text) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PdfFormatEnum {
        DEFAULT("Default"),
        PDFA_1A("PdfA_1A"),
        PDFA_1B("PdfA_1B"),
        PDFA_2A("PdfA_2A"),
        PDFA_3A("PdfA_3A"),
        PDFA_2B("PdfA_2B"),
        PDFA_2U("PdfA_2U"),
        PDFA_3B("PdfA_3B"),
        PDFA_3U("PdfA_3U"),
        V1_3("v1_3"),
        V1_4("v1_4"),
        V1_5("v1_5"),
        V1_6("v1_6"),
        V1_7("v1_7"),
        PDFX_1A("PdfX_1A"),
        PDFX3("PdfX3");

        private String value;

        private PdfFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PdfFormatEnum fromValue(String text) {
            for (PdfFormatEnum b : PdfFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PdfFormatEnum> {
            public void write(JsonWriter jsonWriter, PdfFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PdfFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PdfFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

