/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Html document load options")
public class WebLoadOptions
extends LoadOptions {
    @SerializedName(value="pageNumbering")
    private Boolean pageNumbering = null;
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="usePdf")
    private Boolean usePdf = null;
    @SerializedName(value="renderingMode")
    private RenderingModeEnum renderingMode = null;

    public WebLoadOptions pageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
        return this;
    }

    @ApiModelProperty(required=true, value="Enable or disable generation of page numbering in converted document. Default: false")
    public Boolean getPageNumbering() {
        return this.pageNumbering;
    }

    public void setPageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
    }

    public WebLoadOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Get or sets the encoding to be used when loading the web document. If the property is null the encoding will be determined from document character set attribute")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public WebLoadOptions usePdf(Boolean usePdf) {
        this.usePdf = usePdf;
        return this;
    }

    @ApiModelProperty(required=true, value="Use pdf for the conversion. Default: false")
    public Boolean getUsePdf() {
        return this.usePdf;
    }

    public void setUsePdf(Boolean usePdf) {
        this.usePdf = usePdf;
    }

    public WebLoadOptions renderingMode(RenderingModeEnum renderingMode) {
        this.renderingMode = renderingMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Controls how HTML content is rendered. Default: AbsolutePositioning")
    public RenderingModeEnum getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingModeEnum renderingMode) {
        this.renderingMode = renderingMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebLoadOptions webLoadOptions = (WebLoadOptions)o;
        return Objects.equals(this.pageNumbering, webLoadOptions.pageNumbering) && Objects.equals(this.encoding, webLoadOptions.encoding) && Objects.equals(this.usePdf, webLoadOptions.usePdf) && Objects.equals((Object)this.renderingMode, (Object)webLoadOptions.renderingMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.pageNumbering, this.encoding, this.usePdf, this.renderingMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    pageNumbering: ").append(this.toIndentedString(this.pageNumbering)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    usePdf: ").append(this.toIndentedString(this.usePdf)).append("\n");
        sb.append("    renderingMode: ").append(this.toIndentedString((Object)this.renderingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RenderingModeEnum {
        FLOW("Flow"),
        ABSOLUTEPOSITIONING("AbsolutePositioning");

        private String value;

        private RenderingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RenderingModeEnum fromValue(String text) {
            for (RenderingModeEnum b : RenderingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RenderingModeEnum> {
            public void write(JsonWriter jsonWriter, RenderingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RenderingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RenderingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

