/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options for loading CAD documents")
public class CadLoadOptions
extends LoadOptions {
    @SerializedName(value="layoutNames")
    private List<String> layoutNames = null;
    @SerializedName(value="drawType")
    private DrawTypeEnum drawType = null;
    @SerializedName(value="drawColor")
    private String drawColor = null;
    @SerializedName(value="backgroundColor")
    private String backgroundColor = null;

    public CadLoadOptions layoutNames(List<String> layoutNames) {
        this.layoutNames = layoutNames;
        return this;
    }

    public CadLoadOptions addLayoutNamesItem(String layoutNamesItem) {
        if (this.layoutNames == null) {
            this.layoutNames = new ArrayList<String>();
        }
        this.layoutNames.add(layoutNamesItem);
        return this;
    }

    @ApiModelProperty(value="Render specific CAD layouts")
    public List<String> getLayoutNames() {
        return this.layoutNames;
    }

    public void setLayoutNames(List<String> layoutNames) {
        this.layoutNames = layoutNames;
    }

    public CadLoadOptions drawType(DrawTypeEnum drawType) {
        this.drawType = drawType;
        return this;
    }

    @ApiModelProperty(required=true, value="A type of drawing.")
    public DrawTypeEnum getDrawType() {
        return this.drawType;
    }

    public void setDrawType(DrawTypeEnum drawType) {
        this.drawType = drawType;
    }

    public CadLoadOptions drawColor(String drawColor) {
        this.drawColor = drawColor;
        return this;
    }

    @ApiModelProperty(value="A foreground color.             ")
    public String getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(String drawColor) {
        this.drawColor = drawColor;
    }

    public CadLoadOptions backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="A background color.")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CadLoadOptions cadLoadOptions = (CadLoadOptions)o;
        return Objects.equals(this.layoutNames, cadLoadOptions.layoutNames) && Objects.equals((Object)this.drawType, (Object)cadLoadOptions.drawType) && Objects.equals(this.drawColor, cadLoadOptions.drawColor) && Objects.equals(this.backgroundColor, cadLoadOptions.backgroundColor) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.layoutNames, this.drawType, this.drawColor, this.backgroundColor, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CadLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    layoutNames: ").append(this.toIndentedString(this.layoutNames)).append("\n");
        sb.append("    drawType: ").append(this.toIndentedString((Object)this.drawType)).append("\n");
        sb.append("    drawColor: ").append(this.toIndentedString(this.drawColor)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DrawTypeEnum {
        USEDRAWCOLOR("UseDrawColor"),
        USEOBJECTCOLOR("UseObjectColor");

        private String value;

        private DrawTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DrawTypeEnum fromValue(String text) {
            for (DrawTypeEnum b : DrawTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DrawTypeEnum> {
            public void write(JsonWriter jsonWriter, DrawTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DrawTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DrawTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

