/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.ConvertOptions;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines conversion request")
public class ConvertSettings {
    @SerializedName(value="storageName")
    private String storageName = null;
    @SerializedName(value="filePath")
    private String filePath = null;
    @SerializedName(value="format")
    private String format = null;
    @SerializedName(value="loadOptions")
    private LoadOptions loadOptions = null;
    @SerializedName(value="convertOptions")
    private ConvertOptions convertOptions = null;
    @SerializedName(value="outputPath")
    private String outputPath = null;
    @SerializedName(value="fontsPath")
    private String fontsPath = null;

    public ConvertSettings storageName(String storageName) {
        this.storageName = storageName;
        return this;
    }

    @ApiModelProperty(value="StorageName which contains the file")
    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public ConvertSettings filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets absolute path to a file in the storage")
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public ConvertSettings format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets requested conversion format")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public ConvertSettings loadOptions(LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
        return this;
    }

    @ApiModelProperty(value="Gets or sets format specific load options for source file")
    public LoadOptions getLoadOptions() {
        return this.loadOptions;
    }

    public void setLoadOptions(LoadOptions loadOptions) {
        this.loadOptions = loadOptions;
    }

    public ConvertSettings convertOptions(ConvertOptions convertOptions) {
        this.convertOptions = convertOptions;
        return this;
    }

    @ApiModelProperty(value="Gets or sets format specific convert options for output file")
    public ConvertOptions getConvertOptions() {
        return this.convertOptions;
    }

    public void setConvertOptions(ConvertOptions convertOptions) {
        this.convertOptions = convertOptions;
    }

    public ConvertSettings outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @ApiModelProperty(value="Gets or sets converted file save path")
    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public ConvertSettings fontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
        return this;
    }

    @ApiModelProperty(value="The path to directory containing custom fonts in storage")
    public String getFontsPath() {
        return this.fontsPath;
    }

    public void setFontsPath(String fontsPath) {
        this.fontsPath = fontsPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertSettings convertSettings = (ConvertSettings)o;
        return Objects.equals(this.storageName, convertSettings.storageName) && Objects.equals(this.filePath, convertSettings.filePath) && Objects.equals(this.format, convertSettings.format) && Objects.equals(this.loadOptions, convertSettings.loadOptions) && Objects.equals(this.convertOptions, convertSettings.convertOptions) && Objects.equals(this.outputPath, convertSettings.outputPath) && Objects.equals(this.fontsPath, convertSettings.fontsPath);
    }

    public int hashCode() {
        return Objects.hash(this.storageName, this.filePath, this.format, this.loadOptions, this.convertOptions, this.outputPath, this.fontsPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertSettings {\n");
        sb.append("    storageName: ").append(this.toIndentedString(this.storageName)).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    loadOptions: ").append(this.toIndentedString(this.loadOptions)).append("\n");
        sb.append("    convertOptions: ").append(this.toIndentedString(this.convertOptions)).append("\n");
        sb.append("    outputPath: ").append(this.toIndentedString(this.outputPath)).append("\n");
        sb.append("    fontsPath: ").append(this.toIndentedString(this.fontsPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

