/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.FieldLabel;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Options for loading Email documents")
public class EmailLoadOptions
extends LoadOptions {
    @SerializedName(value="preserveOriginalDate")
    private Boolean preserveOriginalDate = null;
    @SerializedName(value="fieldLabels")
    private List<FieldLabel> fieldLabels = null;
    @SerializedName(value="timeZoneOffset")
    private String timeZoneOffset = null;
    @SerializedName(value="displaySent")
    private Boolean displaySent = null;
    @SerializedName(value="displaySubject")
    private Boolean displaySubject = null;
    @SerializedName(value="displayAttachments")
    private Boolean displayAttachments = null;
    @SerializedName(value="displayEmailAddresses")
    private Boolean displayEmailAddresses = null;
    @SerializedName(value="displayBccEmailAddress")
    private Boolean displayBccEmailAddress = null;
    @SerializedName(value="displayCcEmailAddress")
    private Boolean displayCcEmailAddress = null;
    @SerializedName(value="displayToEmailAddress")
    private Boolean displayToEmailAddress = null;
    @SerializedName(value="displayFromEmailAddress")
    private Boolean displayFromEmailAddress = null;
    @SerializedName(value="displayHeader")
    private Boolean displayHeader = null;
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;

    public EmailLoadOptions preserveOriginalDate(Boolean preserveOriginalDate) {
        this.preserveOriginalDate = preserveOriginalDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines whether need to keep original date header string in mail message when saving or not (Default value is true)")
    public Boolean getPreserveOriginalDate() {
        return this.preserveOriginalDate;
    }

    public void setPreserveOriginalDate(Boolean preserveOriginalDate) {
        this.preserveOriginalDate = preserveOriginalDate;
    }

    public EmailLoadOptions fieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
        return this;
    }

    public EmailLoadOptions addFieldLabelsItem(FieldLabel fieldLabelsItem) {
        if (this.fieldLabels == null) {
            this.fieldLabels = new ArrayList<FieldLabel>();
        }
        this.fieldLabels.add(fieldLabelsItem);
        return this;
    }

    @ApiModelProperty(value="The mapping between email message field and field text representation")
    public List<FieldLabel> getFieldLabels() {
        return this.fieldLabels;
    }

    public void setFieldLabels(List<FieldLabel> fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public EmailLoadOptions timeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the Coordinated Universal Time (UTC) offset for the message dates. This property defines the time zone difference, between the localtime and UTC.")
    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public EmailLoadOptions displaySent(Boolean displaySent) {
        this.displaySent = displaySent;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide sent date/time in the header. Default: true.")
    public Boolean getDisplaySent() {
        return this.displaySent;
    }

    public void setDisplaySent(Boolean displaySent) {
        this.displaySent = displaySent;
    }

    public EmailLoadOptions displaySubject(Boolean displaySubject) {
        this.displaySubject = displaySubject;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide subject in the header. Default: true.")
    public Boolean getDisplaySubject() {
        return this.displaySubject;
    }

    public void setDisplaySubject(Boolean displaySubject) {
        this.displaySubject = displaySubject;
    }

    public EmailLoadOptions displayAttachments(Boolean displayAttachments) {
        this.displayAttachments = displayAttachments;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide attachments in the header. Default: true.")
    public Boolean getDisplayAttachments() {
        return this.displayAttachments;
    }

    public void setDisplayAttachments(Boolean displayAttachments) {
        this.displayAttachments = displayAttachments;
    }

    public EmailLoadOptions displayEmailAddresses(Boolean displayEmailAddresses) {
        this.displayEmailAddresses = displayEmailAddresses;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Boolean getDisplayEmailAddresses() {
        return this.displayEmailAddresses;
    }

    public void setDisplayEmailAddresses(Boolean displayEmailAddresses) {
        this.displayEmailAddresses = displayEmailAddresses;
    }

    public EmailLoadOptions displayBccEmailAddress(Boolean displayBccEmailAddress) {
        this.displayBccEmailAddress = displayBccEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"Bcc\" email address. Default: false")
    public Boolean getDisplayBccEmailAddress() {
        return this.displayBccEmailAddress;
    }

    public void setDisplayBccEmailAddress(Boolean displayBccEmailAddress) {
        this.displayBccEmailAddress = displayBccEmailAddress;
    }

    public EmailLoadOptions displayCcEmailAddress(Boolean displayCcEmailAddress) {
        this.displayCcEmailAddress = displayCcEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"Cc\" email address. Default: false")
    public Boolean getDisplayCcEmailAddress() {
        return this.displayCcEmailAddress;
    }

    public void setDisplayCcEmailAddress(Boolean displayCcEmailAddress) {
        this.displayCcEmailAddress = displayCcEmailAddress;
    }

    public EmailLoadOptions displayToEmailAddress(Boolean displayToEmailAddress) {
        this.displayToEmailAddress = displayToEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"to\" email address. Default: true")
    public Boolean getDisplayToEmailAddress() {
        return this.displayToEmailAddress;
    }

    public void setDisplayToEmailAddress(Boolean displayToEmailAddress) {
        this.displayToEmailAddress = displayToEmailAddress;
    }

    public EmailLoadOptions displayFromEmailAddress(Boolean displayFromEmailAddress) {
        this.displayFromEmailAddress = displayFromEmailAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide \"from\" email address. Default: true")
    public Boolean getDisplayFromEmailAddress() {
        return this.displayFromEmailAddress;
    }

    public void setDisplayFromEmailAddress(Boolean displayFromEmailAddress) {
        this.displayFromEmailAddress = displayFromEmailAddress;
    }

    public EmailLoadOptions displayHeader(Boolean displayHeader) {
        this.displayHeader = displayHeader;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to display or hide the email header. Default: true")
    public Boolean getDisplayHeader() {
        return this.displayHeader;
    }

    public void setDisplayHeader(Boolean displayHeader) {
        this.displayHeader = displayHeader;
    }

    public EmailLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Email document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public EmailLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public EmailLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="List of font substitutes.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailLoadOptions emailLoadOptions = (EmailLoadOptions)o;
        return Objects.equals(this.preserveOriginalDate, emailLoadOptions.preserveOriginalDate) && Objects.equals(this.fieldLabels, emailLoadOptions.fieldLabels) && Objects.equals(this.timeZoneOffset, emailLoadOptions.timeZoneOffset) && Objects.equals(this.displaySent, emailLoadOptions.displaySent) && Objects.equals(this.displaySubject, emailLoadOptions.displaySubject) && Objects.equals(this.displayAttachments, emailLoadOptions.displayAttachments) && Objects.equals(this.displayEmailAddresses, emailLoadOptions.displayEmailAddresses) && Objects.equals(this.displayBccEmailAddress, emailLoadOptions.displayBccEmailAddress) && Objects.equals(this.displayCcEmailAddress, emailLoadOptions.displayCcEmailAddress) && Objects.equals(this.displayToEmailAddress, emailLoadOptions.displayToEmailAddress) && Objects.equals(this.displayFromEmailAddress, emailLoadOptions.displayFromEmailAddress) && Objects.equals(this.displayHeader, emailLoadOptions.displayHeader) && Objects.equals(this.defaultFont, emailLoadOptions.defaultFont) && Objects.equals(this.fontSubstitutes, emailLoadOptions.fontSubstitutes) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.preserveOriginalDate, this.fieldLabels, this.timeZoneOffset, this.displaySent, this.displaySubject, this.displayAttachments, this.displayEmailAddresses, this.displayBccEmailAddress, this.displayCcEmailAddress, this.displayToEmailAddress, this.displayFromEmailAddress, this.displayHeader, this.defaultFont, this.fontSubstitutes, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    preserveOriginalDate: ").append(this.toIndentedString(this.preserveOriginalDate)).append("\n");
        sb.append("    fieldLabels: ").append(this.toIndentedString(this.fieldLabels)).append("\n");
        sb.append("    timeZoneOffset: ").append(this.toIndentedString(this.timeZoneOffset)).append("\n");
        sb.append("    displaySent: ").append(this.toIndentedString(this.displaySent)).append("\n");
        sb.append("    displaySubject: ").append(this.toIndentedString(this.displaySubject)).append("\n");
        sb.append("    displayAttachments: ").append(this.toIndentedString(this.displayAttachments)).append("\n");
        sb.append("    displayEmailAddresses: ").append(this.toIndentedString(this.displayEmailAddresses)).append("\n");
        sb.append("    displayBccEmailAddress: ").append(this.toIndentedString(this.displayBccEmailAddress)).append("\n");
        sb.append("    displayCcEmailAddress: ").append(this.toIndentedString(this.displayCcEmailAddress)).append("\n");
        sb.append("    displayToEmailAddress: ").append(this.toIndentedString(this.displayToEmailAddress)).append("\n");
        sb.append("    displayFromEmailAddress: ").append(this.toIndentedString(this.displayFromEmailAddress)).append("\n");
        sb.append("    displayHeader: ").append(this.toIndentedString(this.displayHeader)).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

