/**
 * --------------------------------------------------------------------------------------------------------------------
 * <copyright company="Aspose Pty Ltd" file="ConsumptionResult.java">
 *   Copyright (c) Aspose Pty Ltd
 * </copyright>
 * <summary>
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 * </summary>
 * --------------------------------------------------------------------------------------------------------------------
 */

package com.groupdocs.cloud.conversion.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * Metered license consumption information
 */
@ApiModel(description = "Metered license consumption information")
public class ConsumptionResult {
  @SerializedName("credit")
  private BigDecimal credit = null;

  @SerializedName("quantity")
  private BigDecimal quantity = null;

  @SerializedName("billedApiCalls")
  private BigDecimal billedApiCalls = null;

  public ConsumptionResult credit(BigDecimal credit) {
    this.credit = credit;
    return this;
  }

   /**
   * Amount of used credits
   * @return credit
  **/
  @ApiModelProperty(required = true, value = "Amount of used credits")
  public BigDecimal getCredit() {
    return credit;
  }

  public void setCredit(BigDecimal credit) {
    this.credit = credit;
  }

  public ConsumptionResult quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * Amount of MBs processed
   * @return quantity
  **/
  @ApiModelProperty(required = true, value = "Amount of MBs processed")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  public ConsumptionResult billedApiCalls(BigDecimal billedApiCalls) {
    this.billedApiCalls = billedApiCalls;
    return this;
  }

   /**
   * Billed API calls number
   * @return billedApiCalls
  **/
  @ApiModelProperty(required = true, value = "Billed API calls number")
  public BigDecimal getBilledApiCalls() {
    return billedApiCalls;
  }

  public void setBilledApiCalls(BigDecimal billedApiCalls) {
    this.billedApiCalls = billedApiCalls;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumptionResult consumptionResult = (ConsumptionResult) o;
    return Objects.equals(this.credit, consumptionResult.credit) &&
        Objects.equals(this.quantity, consumptionResult.quantity) &&
        Objects.equals(this.billedApiCalls, consumptionResult.billedApiCalls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(credit, quantity, billedApiCalls);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumptionResult {\n");
    
    sb.append("    credit: ").append(toIndentedString(credit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    billedApiCalls: ").append(toIndentedString(billedApiCalls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

