/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.conversion.model.WatermarkOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ConvertOptions base")
public class ConvertOptions {
    @SerializedName(value="fromPage")
    private Integer fromPage = null;
    @SerializedName(value="pagesCount")
    private Integer pagesCount = null;
    @SerializedName(value="pages")
    private List<Integer> pages = null;
    @SerializedName(value="watermarkOptions")
    private WatermarkOptions watermarkOptions = null;

    public ConvertOptions fromPage(Integer fromPage) {
        this.fromPage = fromPage;
        return this;
    }

    @ApiModelProperty(required=true, value="Start conversion from FromPage page")
    public Integer getFromPage() {
        return this.fromPage;
    }

    public void setFromPage(Integer fromPage) {
        this.fromPage = fromPage;
    }

    public ConvertOptions pagesCount(Integer pagesCount) {
        this.pagesCount = pagesCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of pages to convert")
    public Integer getPagesCount() {
        return this.pagesCount;
    }

    public void setPagesCount(Integer pagesCount) {
        this.pagesCount = pagesCount;
    }

    public ConvertOptions pages(List<Integer> pages) {
        this.pages = pages;
        return this;
    }

    public ConvertOptions addPagesItem(Integer pagesItem) {
        if (this.pages == null) {
            this.pages = new ArrayList<Integer>();
        }
        this.pages.add(pagesItem);
        return this;
    }

    @ApiModelProperty(value="Convert specific pages. The list contains the page indexes of the pages to be converted")
    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(List<Integer> pages) {
        this.pages = pages;
    }

    public ConvertOptions watermarkOptions(WatermarkOptions watermarkOptions) {
        this.watermarkOptions = watermarkOptions;
        return this;
    }

    @ApiModelProperty(value="Watermark specific options")
    public WatermarkOptions getWatermarkOptions() {
        return this.watermarkOptions;
    }

    public void setWatermarkOptions(WatermarkOptions watermarkOptions) {
        this.watermarkOptions = watermarkOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertOptions convertOptions = (ConvertOptions)o;
        return Objects.equals(this.fromPage, convertOptions.fromPage) && Objects.equals(this.pagesCount, convertOptions.pagesCount) && Objects.equals(this.pages, convertOptions.pages) && Objects.equals(this.watermarkOptions, convertOptions.watermarkOptions);
    }

    public int hashCode() {
        return Objects.hash(this.fromPage, this.pagesCount, this.pages, this.watermarkOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertOptions {\n");
        sb.append("    fromPage: ").append(this.toIndentedString(this.fromPage)).append("\n");
        sb.append("    pagesCount: ").append(this.toIndentedString(this.pagesCount)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    watermarkOptions: ").append(this.toIndentedString(this.watermarkOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

