/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Spreadsheet document load options")
public class SpreadsheetLoadOptions
extends LoadOptions {
    @SerializedName(value="clearCustomDocumentProperties")
    private Boolean clearCustomDocumentProperties = null;
    @SerializedName(value="clearBuiltInDocumentProperties")
    private Boolean clearBuiltInDocumentProperties = null;
    @SerializedName(value="rowsPerPage")
    private Integer rowsPerPage = null;
    @SerializedName(value="columnsPerPage")
    private Integer columnsPerPage = null;
    @SerializedName(value="autoFitRows")
    private Boolean autoFitRows = null;
    @SerializedName(value="allColumnsInOnePagePerSheet")
    private Boolean allColumnsInOnePagePerSheet = null;
    @SerializedName(value="cultureInfo")
    private String cultureInfo = null;
    @SerializedName(value="checkExcelRestriction")
    private Boolean checkExcelRestriction = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="skipEmptyRowsAndColumns")
    private Boolean skipEmptyRowsAndColumns = null;
    @SerializedName(value="convertRange")
    private String convertRange = null;
    @SerializedName(value="optimizePdfSize")
    private Boolean optimizePdfSize = null;
    @SerializedName(value="onePagePerSheet")
    private Boolean onePagePerSheet = null;
    @SerializedName(value="showHiddenSheets")
    private Boolean showHiddenSheets = null;
    @SerializedName(value="showGridLines")
    private Boolean showGridLines = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="sheetIndexes")
    private List<Integer> sheetIndexes = null;
    @SerializedName(value="sheets")
    private List<String> sheets = null;
    @SerializedName(value="printComments")
    private PrintCommentsEnum printComments = null;
    @SerializedName(value="resetFontFolders")
    private Boolean resetFontFolders = null;

    public SpreadsheetLoadOptions clearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear custom document properties. Default is false.")
    public Boolean getClearCustomDocumentProperties() {
        return this.clearCustomDocumentProperties;
    }

    public void setClearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
    }

    public SpreadsheetLoadOptions clearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear built-in document properties. Default is false.")
    public Boolean getClearBuiltInDocumentProperties() {
        return this.clearBuiltInDocumentProperties;
    }

    public void setClearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
    }

    public SpreadsheetLoadOptions rowsPerPage(Integer rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
        return this;
    }

    @ApiModelProperty(required=true, value="Split a worksheet into pages by rows. Default is 0, no pagination.")
    public Integer getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(Integer rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public SpreadsheetLoadOptions columnsPerPage(Integer columnsPerPage) {
        this.columnsPerPage = columnsPerPage;
        return this;
    }

    @ApiModelProperty(required=true, value="Split a worksheet into pages by columns. Default is 0, no pagination.")
    public Integer getColumnsPerPage() {
        return this.columnsPerPage;
    }

    public void setColumnsPerPage(Integer columnsPerPage) {
        this.columnsPerPage = columnsPerPage;
    }

    public SpreadsheetLoadOptions autoFitRows(Boolean autoFitRows) {
        this.autoFitRows = autoFitRows;
        return this;
    }

    @ApiModelProperty(required=true, value="Autofits all rows when converting")
    public Boolean getAutoFitRows() {
        return this.autoFitRows;
    }

    public void setAutoFitRows(Boolean autoFitRows) {
        this.autoFitRows = autoFitRows;
    }

    public SpreadsheetLoadOptions allColumnsInOnePagePerSheet(Boolean allColumnsInOnePagePerSheet) {
        this.allColumnsInOnePagePerSheet = allColumnsInOnePagePerSheet;
        return this;
    }

    @ApiModelProperty(required=true, value="If AllColumnsInOnePagePerSheet is true, all column content of one sheet will output to only one page in result. The width of paper size of pagesetup will be invalid, and the other settings of pagesetup will still take effect.             ")
    public Boolean getAllColumnsInOnePagePerSheet() {
        return this.allColumnsInOnePagePerSheet;
    }

    public void setAllColumnsInOnePagePerSheet(Boolean allColumnsInOnePagePerSheet) {
        this.allColumnsInOnePagePerSheet = allColumnsInOnePagePerSheet;
    }

    public SpreadsheetLoadOptions cultureInfo(String cultureInfo) {
        this.cultureInfo = cultureInfo;
        return this;
    }

    @ApiModelProperty(value="System culture info at the time file is loaded")
    public String getCultureInfo() {
        return this.cultureInfo;
    }

    public void setCultureInfo(String cultureInfo) {
        this.cultureInfo = cultureInfo;
    }

    public SpreadsheetLoadOptions checkExcelRestriction(Boolean checkExcelRestriction) {
        this.checkExcelRestriction = checkExcelRestriction;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether check restriction of excel file when user modify cells related objects. For example, excel does not allow inputting string value longer than 32K. When you input a value longer than 32K, if this property is true, you will get an Exception. If this property is false, we will accept your input string value as the cell's value so that later you can output the complete string value for other file formats such as CSV. However, if you have set such kind of value that is invalid for excel file format, you should not save the workbook as excel file format later. Otherwise there may be unexpected error for the generated excel file.             ")
    public Boolean getCheckExcelRestriction() {
        return this.checkExcelRestriction;
    }

    public void setCheckExcelRestriction(Boolean checkExcelRestriction) {
        this.checkExcelRestriction = checkExcelRestriction;
    }

    public SpreadsheetLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SpreadsheetLoadOptions skipEmptyRowsAndColumns(Boolean skipEmptyRowsAndColumns) {
        this.skipEmptyRowsAndColumns = skipEmptyRowsAndColumns;
        return this;
    }

    @ApiModelProperty(required=true, value="Skips empty rows and columns when converting. Default is True.")
    public Boolean getSkipEmptyRowsAndColumns() {
        return this.skipEmptyRowsAndColumns;
    }

    public void setSkipEmptyRowsAndColumns(Boolean skipEmptyRowsAndColumns) {
        this.skipEmptyRowsAndColumns = skipEmptyRowsAndColumns;
    }

    public SpreadsheetLoadOptions convertRange(String convertRange) {
        this.convertRange = convertRange;
        return this;
    }

    @ApiModelProperty(value="Convert specific range when converting to other than cells format. Example: \"D1:F8\"")
    public String getConvertRange() {
        return this.convertRange;
    }

    public void setConvertRange(String convertRange) {
        this.convertRange = convertRange;
    }

    public SpreadsheetLoadOptions optimizePdfSize(Boolean optimizePdfSize) {
        this.optimizePdfSize = optimizePdfSize;
        return this;
    }

    @ApiModelProperty(required=true, value="If True and converting to Pdf the conversion is optimized for better file size than print quality.             ")
    public Boolean getOptimizePdfSize() {
        return this.optimizePdfSize;
    }

    public void setOptimizePdfSize(Boolean optimizePdfSize) {
        this.optimizePdfSize = optimizePdfSize;
    }

    public SpreadsheetLoadOptions onePagePerSheet(Boolean onePagePerSheet) {
        this.onePagePerSheet = onePagePerSheet;
        return this;
    }

    @ApiModelProperty(required=true, value="If OnePagePerSheet is true the content of the sheet will be converted to one page in the PDF document. Default value is true.")
    public Boolean getOnePagePerSheet() {
        return this.onePagePerSheet;
    }

    public void setOnePagePerSheet(Boolean onePagePerSheet) {
        this.onePagePerSheet = onePagePerSheet;
    }

    public SpreadsheetLoadOptions showHiddenSheets(Boolean showHiddenSheets) {
        this.showHiddenSheets = showHiddenSheets;
        return this;
    }

    @ApiModelProperty(required=true, value="Show hidden sheets when converting Excel files")
    public Boolean getShowHiddenSheets() {
        return this.showHiddenSheets;
    }

    public void setShowHiddenSheets(Boolean showHiddenSheets) {
        this.showHiddenSheets = showHiddenSheets;
    }

    public SpreadsheetLoadOptions showGridLines(Boolean showGridLines) {
        this.showGridLines = showGridLines;
        return this;
    }

    @ApiModelProperty(required=true, value="Show grid lines when converting Excel files")
    public Boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(Boolean showGridLines) {
        this.showGridLines = showGridLines;
    }

    public SpreadsheetLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public SpreadsheetLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Cells document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public SpreadsheetLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Cells document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public SpreadsheetLoadOptions sheetIndexes(List<Integer> sheetIndexes) {
        this.sheetIndexes = sheetIndexes;
        return this;
    }

    public SpreadsheetLoadOptions addSheetIndexesItem(Integer sheetIndexesItem) {
        if (this.sheetIndexes == null) {
            this.sheetIndexes = new ArrayList<Integer>();
        }
        this.sheetIndexes.add(sheetIndexesItem);
        return this;
    }

    @ApiModelProperty(value="List of sheet indexes to convert. The indexes must be zero-based")
    public List<Integer> getSheetIndexes() {
        return this.sheetIndexes;
    }

    public void setSheetIndexes(List<Integer> sheetIndexes) {
        this.sheetIndexes = sheetIndexes;
    }

    public SpreadsheetLoadOptions sheets(List<String> sheets) {
        this.sheets = sheets;
        return this;
    }

    public SpreadsheetLoadOptions addSheetsItem(String sheetsItem) {
        if (this.sheets == null) {
            this.sheets = new ArrayList<String>();
        }
        this.sheets.add(sheetsItem);
        return this;
    }

    @ApiModelProperty(value="List of sheet names to convert")
    public List<String> getSheets() {
        return this.sheets;
    }

    public void setSheets(List<String> sheets) {
        this.sheets = sheets;
    }

    public SpreadsheetLoadOptions printComments(PrintCommentsEnum printComments) {
        this.printComments = printComments;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the way comments are printed with the sheet. Default is PrintNoComments.")
    public PrintCommentsEnum getPrintComments() {
        return this.printComments;
    }

    public void setPrintComments(PrintCommentsEnum printComments) {
        this.printComments = printComments;
    }

    public SpreadsheetLoadOptions resetFontFolders(Boolean resetFontFolders) {
        this.resetFontFolders = resetFontFolders;
        return this;
    }

    @ApiModelProperty(required=true, value="Reset font folders before loading document")
    public Boolean getResetFontFolders() {
        return this.resetFontFolders;
    }

    public void setResetFontFolders(Boolean resetFontFolders) {
        this.resetFontFolders = resetFontFolders;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpreadsheetLoadOptions spreadsheetLoadOptions = (SpreadsheetLoadOptions)o;
        return Objects.equals(this.clearCustomDocumentProperties, spreadsheetLoadOptions.clearCustomDocumentProperties) && Objects.equals(this.clearBuiltInDocumentProperties, spreadsheetLoadOptions.clearBuiltInDocumentProperties) && Objects.equals(this.rowsPerPage, spreadsheetLoadOptions.rowsPerPage) && Objects.equals(this.columnsPerPage, spreadsheetLoadOptions.columnsPerPage) && Objects.equals(this.autoFitRows, spreadsheetLoadOptions.autoFitRows) && Objects.equals(this.allColumnsInOnePagePerSheet, spreadsheetLoadOptions.allColumnsInOnePagePerSheet) && Objects.equals(this.cultureInfo, spreadsheetLoadOptions.cultureInfo) && Objects.equals(this.checkExcelRestriction, spreadsheetLoadOptions.checkExcelRestriction) && Objects.equals(this.password, spreadsheetLoadOptions.password) && Objects.equals(this.skipEmptyRowsAndColumns, spreadsheetLoadOptions.skipEmptyRowsAndColumns) && Objects.equals(this.convertRange, spreadsheetLoadOptions.convertRange) && Objects.equals(this.optimizePdfSize, spreadsheetLoadOptions.optimizePdfSize) && Objects.equals(this.onePagePerSheet, spreadsheetLoadOptions.onePagePerSheet) && Objects.equals(this.showHiddenSheets, spreadsheetLoadOptions.showHiddenSheets) && Objects.equals(this.showGridLines, spreadsheetLoadOptions.showGridLines) && Objects.equals(this.fontSubstitutes, spreadsheetLoadOptions.fontSubstitutes) && Objects.equals(this.defaultFont, spreadsheetLoadOptions.defaultFont) && Objects.equals(this.sheetIndexes, spreadsheetLoadOptions.sheetIndexes) && Objects.equals(this.sheets, spreadsheetLoadOptions.sheets) && Objects.equals((Object)this.printComments, (Object)spreadsheetLoadOptions.printComments) && Objects.equals(this.resetFontFolders, spreadsheetLoadOptions.resetFontFolders) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.clearCustomDocumentProperties, this.clearBuiltInDocumentProperties, this.rowsPerPage, this.columnsPerPage, this.autoFitRows, this.allColumnsInOnePagePerSheet, this.cultureInfo, this.checkExcelRestriction, this.password, this.skipEmptyRowsAndColumns, this.convertRange, this.optimizePdfSize, this.onePagePerSheet, this.showHiddenSheets, this.showGridLines, this.fontSubstitutes, this.defaultFont, this.sheetIndexes, this.sheets, this.printComments, this.resetFontFolders, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpreadsheetLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    clearCustomDocumentProperties: ").append(this.toIndentedString(this.clearCustomDocumentProperties)).append("\n");
        sb.append("    clearBuiltInDocumentProperties: ").append(this.toIndentedString(this.clearBuiltInDocumentProperties)).append("\n");
        sb.append("    rowsPerPage: ").append(this.toIndentedString(this.rowsPerPage)).append("\n");
        sb.append("    columnsPerPage: ").append(this.toIndentedString(this.columnsPerPage)).append("\n");
        sb.append("    autoFitRows: ").append(this.toIndentedString(this.autoFitRows)).append("\n");
        sb.append("    allColumnsInOnePagePerSheet: ").append(this.toIndentedString(this.allColumnsInOnePagePerSheet)).append("\n");
        sb.append("    cultureInfo: ").append(this.toIndentedString(this.cultureInfo)).append("\n");
        sb.append("    checkExcelRestriction: ").append(this.toIndentedString(this.checkExcelRestriction)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    skipEmptyRowsAndColumns: ").append(this.toIndentedString(this.skipEmptyRowsAndColumns)).append("\n");
        sb.append("    convertRange: ").append(this.toIndentedString(this.convertRange)).append("\n");
        sb.append("    optimizePdfSize: ").append(this.toIndentedString(this.optimizePdfSize)).append("\n");
        sb.append("    onePagePerSheet: ").append(this.toIndentedString(this.onePagePerSheet)).append("\n");
        sb.append("    showHiddenSheets: ").append(this.toIndentedString(this.showHiddenSheets)).append("\n");
        sb.append("    showGridLines: ").append(this.toIndentedString(this.showGridLines)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    sheetIndexes: ").append(this.toIndentedString(this.sheetIndexes)).append("\n");
        sb.append("    sheets: ").append(this.toIndentedString(this.sheets)).append("\n");
        sb.append("    printComments: ").append(this.toIndentedString((Object)this.printComments)).append("\n");
        sb.append("    resetFontFolders: ").append(this.toIndentedString(this.resetFontFolders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PrintCommentsEnum {
        PRINTINPLACE("PrintInPlace"),
        PRINTNOCOMMENTS("PrintNoComments"),
        PRINTSHEETEND("PrintSheetEnd"),
        PRINTWITHTHREADEDCOMMENTS("PrintWithThreadedComments");

        private String value;

        private PrintCommentsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PrintCommentsEnum fromValue(String text) {
            for (PrintCommentsEnum b : PrintCommentsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PrintCommentsEnum> {
            public void write(JsonWriter jsonWriter, PrintCommentsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PrintCommentsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PrintCommentsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

