/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents information about supported conversion for SourceFormat")
public class SupportedFormat {
    @SerializedName(value="sourceFormat")
    private String sourceFormat = null;
    @SerializedName(value="targetFormats")
    private List<String> targetFormats = null;

    public SupportedFormat sourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
        return this;
    }

    @ApiModelProperty(value="Gets or sets source format")
    public String getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public SupportedFormat targetFormats(List<String> targetFormats) {
        this.targetFormats = targetFormats;
        return this;
    }

    public SupportedFormat addTargetFormatsItem(String targetFormatsItem) {
        if (this.targetFormats == null) {
            this.targetFormats = new ArrayList<String>();
        }
        this.targetFormats.add(targetFormatsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets target formats")
    public List<String> getTargetFormats() {
        return this.targetFormats;
    }

    public void setTargetFormats(List<String> targetFormats) {
        this.targetFormats = targetFormats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedFormat supportedFormat = (SupportedFormat)o;
        return Objects.equals(this.sourceFormat, supportedFormat.sourceFormat) && Objects.equals(this.targetFormats, supportedFormat.targetFormats);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFormat, this.targetFormats);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedFormat {\n");
        sb.append("    sourceFormat: ").append(this.toIndentedString(this.sourceFormat)).append("\n");
        sb.append("    targetFormats: ").append(this.toIndentedString(this.targetFormats)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

