/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Txt document load options")
public class TxtLoadOptions
extends LoadOptions {
    @SerializedName(value="detectNumberingWithWhitespaces")
    private Boolean detectNumberingWithWhitespaces = null;
    @SerializedName(value="trailingSpacesOptions")
    private TrailingSpacesOptionsEnum trailingSpacesOptions = null;
    @SerializedName(value="leadingSpacesOptions")
    private LeadingSpacesOptionsEnum leadingSpacesOptions = null;
    @SerializedName(value="encoding")
    private String encoding = null;

    public TxtLoadOptions detectNumberingWithWhitespaces(Boolean detectNumberingWithWhitespaces) {
        this.detectNumberingWithWhitespaces = detectNumberingWithWhitespaces;
        return this;
    }

    @ApiModelProperty(required=true, value="Allows to specify how numbered list items are recognized when plain text document is converted. The default value is true.")
    public Boolean getDetectNumberingWithWhitespaces() {
        return this.detectNumberingWithWhitespaces;
    }

    public void setDetectNumberingWithWhitespaces(Boolean detectNumberingWithWhitespaces) {
        this.detectNumberingWithWhitespaces = detectNumberingWithWhitespaces;
    }

    public TxtLoadOptions trailingSpacesOptions(TrailingSpacesOptionsEnum trailingSpacesOptions) {
        this.trailingSpacesOptions = trailingSpacesOptions;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets preferred option of a trailing space handling. Default value is Trim.")
    public TrailingSpacesOptionsEnum getTrailingSpacesOptions() {
        return this.trailingSpacesOptions;
    }

    public void setTrailingSpacesOptions(TrailingSpacesOptionsEnum trailingSpacesOptions) {
        this.trailingSpacesOptions = trailingSpacesOptions;
    }

    public TxtLoadOptions leadingSpacesOptions(LeadingSpacesOptionsEnum leadingSpacesOptions) {
        this.leadingSpacesOptions = leadingSpacesOptions;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets preferred option of a leading space handling. Default value is ConvertToIndent.")
    public LeadingSpacesOptionsEnum getLeadingSpacesOptions() {
        return this.leadingSpacesOptions;
    }

    public void setLeadingSpacesOptions(LeadingSpacesOptionsEnum leadingSpacesOptions) {
        this.leadingSpacesOptions = leadingSpacesOptions;
    }

    public TxtLoadOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the encoding that will be used when loading Txt document. Can be null. Default is null.")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxtLoadOptions txtLoadOptions = (TxtLoadOptions)o;
        return Objects.equals(this.detectNumberingWithWhitespaces, txtLoadOptions.detectNumberingWithWhitespaces) && Objects.equals((Object)this.trailingSpacesOptions, (Object)txtLoadOptions.trailingSpacesOptions) && Objects.equals((Object)this.leadingSpacesOptions, (Object)txtLoadOptions.leadingSpacesOptions) && Objects.equals(this.encoding, txtLoadOptions.encoding) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.detectNumberingWithWhitespaces, this.trailingSpacesOptions, this.leadingSpacesOptions, this.encoding, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TxtLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    detectNumberingWithWhitespaces: ").append(this.toIndentedString(this.detectNumberingWithWhitespaces)).append("\n");
        sb.append("    trailingSpacesOptions: ").append(this.toIndentedString((Object)this.trailingSpacesOptions)).append("\n");
        sb.append("    leadingSpacesOptions: ").append(this.toIndentedString((Object)this.leadingSpacesOptions)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LeadingSpacesOptionsEnum {
        CONVERTTOINDENT("ConvertToIndent"),
        PRESERVE("Preserve"),
        TRIM("Trim");

        private String value;

        private LeadingSpacesOptionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LeadingSpacesOptionsEnum fromValue(String text) {
            for (LeadingSpacesOptionsEnum b : LeadingSpacesOptionsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LeadingSpacesOptionsEnum> {
            public void write(JsonWriter jsonWriter, LeadingSpacesOptionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LeadingSpacesOptionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LeadingSpacesOptionsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TrailingSpacesOptionsEnum {
        PRESERVE("Preserve"),
        TRIM("Trim");

        private String value;

        private TrailingSpacesOptionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TrailingSpacesOptionsEnum fromValue(String text) {
            for (TrailingSpacesOptionsEnum b : TrailingSpacesOptionsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TrailingSpacesOptionsEnum> {
            public void write(JsonWriter jsonWriter, TrailingSpacesOptionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TrailingSpacesOptionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TrailingSpacesOptionsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

