/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.conversion.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.conversion.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="WordProcessing document load options")
public class WordProcessingLoadOptions
extends LoadOptions {
    @SerializedName(value="defaultFont")
    private String defaultFont = null;
    @SerializedName(value="fontSubstitutes")
    private Map<String, String> fontSubstitutes = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="hideWordTrackedChanges")
    private Boolean hideWordTrackedChanges = null;
    @SerializedName(value="bookmarksOutlineLevel")
    private Integer bookmarksOutlineLevel = null;
    @SerializedName(value="headingsOutlineLevels")
    private Integer headingsOutlineLevels = null;
    @SerializedName(value="expandedOutlineLevels")
    private Integer expandedOutlineLevels = null;
    @SerializedName(value="clearCustomDocumentProperties")
    private Boolean clearCustomDocumentProperties = null;
    @SerializedName(value="clearBuiltInDocumentProperties")
    private Boolean clearBuiltInDocumentProperties = null;
    @SerializedName(value="depth")
    private Integer depth = null;
    @SerializedName(value="convertOwned")
    private Boolean convertOwned = null;
    @SerializedName(value="convertOwner")
    private Boolean convertOwner = null;
    @SerializedName(value="autoHyphenation")
    private Boolean autoHyphenation = null;
    @SerializedName(value="hyphenateCaps")
    private Boolean hyphenateCaps = null;
    @SerializedName(value="pageNumbering")
    private Boolean pageNumbering = null;
    @SerializedName(value="preserveDocumentStructure")
    private Boolean preserveDocumentStructure = null;
    @SerializedName(value="skipExternalResources")
    private Boolean skipExternalResources = null;
    @SerializedName(value="useTextShaper")
    private Boolean useTextShaper = null;
    @SerializedName(value="preserveFormFields")
    private Boolean preserveFormFields = null;
    @SerializedName(value="commentDisplayMode")
    private CommentDisplayModeEnum commentDisplayMode = null;
    @SerializedName(value="keepDateFieldOriginalValue")
    private Boolean keepDateFieldOriginalValue = null;
    @SerializedName(value="updateFields")
    private Boolean updateFields = null;
    @SerializedName(value="updatePageLayout")
    private Boolean updatePageLayout = null;
    @SerializedName(value="embedTrueTypeFonts")
    private Boolean embedTrueTypeFonts = null;
    @SerializedName(value="fontInfoSubstitutionEnabled")
    private Boolean fontInfoSubstitutionEnabled = null;
    @SerializedName(value="fontConfigSubstitutionEnabled")
    private Boolean fontConfigSubstitutionEnabled = null;
    @SerializedName(value="fontNameSubstitutionEnabled")
    private Boolean fontNameSubstitutionEnabled = null;
    @SerializedName(value="showFullCommenterName")
    private Boolean showFullCommenterName = null;

    public WordProcessingLoadOptions defaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    @ApiModelProperty(value="Default font for Words document. The following font will be used if a font is missing.")
    public String getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    public WordProcessingLoadOptions fontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
        return this;
    }

    public WordProcessingLoadOptions putFontSubstitutesItem(String key, String fontSubstitutesItem) {
        if (this.fontSubstitutes == null) {
            this.fontSubstitutes = new HashMap<String, String>();
        }
        this.fontSubstitutes.put(key, fontSubstitutesItem);
        return this;
    }

    @ApiModelProperty(value="Substitute specific fonts when converting Words document.")
    public Map<String, String> getFontSubstitutes() {
        return this.fontSubstitutes;
    }

    public void setFontSubstitutes(Map<String, String> fontSubstitutes) {
        this.fontSubstitutes = fontSubstitutes;
    }

    public WordProcessingLoadOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Set password to unprotect protected document")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WordProcessingLoadOptions hideWordTrackedChanges(Boolean hideWordTrackedChanges) {
        this.hideWordTrackedChanges = hideWordTrackedChanges;
        return this;
    }

    @ApiModelProperty(required=true, value="Hide markup and track changes for Word documents")
    public Boolean getHideWordTrackedChanges() {
        return this.hideWordTrackedChanges;
    }

    public void setHideWordTrackedChanges(Boolean hideWordTrackedChanges) {
        this.hideWordTrackedChanges = hideWordTrackedChanges;
    }

    public WordProcessingLoadOptions bookmarksOutlineLevel(Integer bookmarksOutlineLevel) {
        this.bookmarksOutlineLevel = bookmarksOutlineLevel;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the default level in the document outline at which to display Word bookmarks. Default is 0. Valid range is 0 to 9.")
    public Integer getBookmarksOutlineLevel() {
        return this.bookmarksOutlineLevel;
    }

    public void setBookmarksOutlineLevel(Integer bookmarksOutlineLevel) {
        this.bookmarksOutlineLevel = bookmarksOutlineLevel;
    }

    public WordProcessingLoadOptions headingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies how many levels of headings (paragraphs formatted with the Heading styles) to include in the document outline. Default is 0. Valid range is 0 to 9.")
    public Integer getHeadingsOutlineLevels() {
        return this.headingsOutlineLevels;
    }

    public void setHeadingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
    }

    public WordProcessingLoadOptions expandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies how many levels in the document outline to show expanded when the file is viewed. Default is 0. Valid range is 0 to 9. Note that this options will not work when saving to XPS.")
    public Integer getExpandedOutlineLevels() {
        return this.expandedOutlineLevels;
    }

    public void setExpandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
    }

    public WordProcessingLoadOptions clearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear custom document properties. Default is false.")
    public Boolean getClearCustomDocumentProperties() {
        return this.clearCustomDocumentProperties;
    }

    public void setClearCustomDocumentProperties(Boolean clearCustomDocumentProperties) {
        this.clearCustomDocumentProperties = clearCustomDocumentProperties;
    }

    public WordProcessingLoadOptions clearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
        return this;
    }

    @ApiModelProperty(required=true, value="Clear built-in document properties. Default is false.")
    public Boolean getClearBuiltInDocumentProperties() {
        return this.clearBuiltInDocumentProperties;
    }

    public void setClearBuiltInDocumentProperties(Boolean clearBuiltInDocumentProperties) {
        this.clearBuiltInDocumentProperties = clearBuiltInDocumentProperties;
    }

    public WordProcessingLoadOptions depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to control how many levels in depth to perform conversion. Default: 1.")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public WordProcessingLoadOptions convertOwned(Boolean convertOwned) {
        this.convertOwned = convertOwned;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to control whether the owned documents in the documents container must be converted")
    public Boolean getConvertOwned() {
        return this.convertOwned;
    }

    public void setConvertOwned(Boolean convertOwned) {
        this.convertOwned = convertOwned;
    }

    public WordProcessingLoadOptions convertOwner(Boolean convertOwner) {
        this.convertOwner = convertOwner;
        return this;
    }

    @ApiModelProperty(required=true, value="Option to control whether the documents container itself must be converted If this property is true the documents container will be the first converted document. Default is true.")
    public Boolean getConvertOwner() {
        return this.convertOwner;
    }

    public void setConvertOwner(Boolean convertOwner) {
        this.convertOwner = convertOwner;
    }

    public WordProcessingLoadOptions autoHyphenation(Boolean autoHyphenation) {
        this.autoHyphenation = autoHyphenation;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets value determining whether automatic hyphenation is turned on for the document. Default value for this property is false.")
    public Boolean getAutoHyphenation() {
        return this.autoHyphenation;
    }

    public void setAutoHyphenation(Boolean autoHyphenation) {
        this.autoHyphenation = autoHyphenation;
    }

    public WordProcessingLoadOptions hyphenateCaps(Boolean hyphenateCaps) {
        this.hyphenateCaps = hyphenateCaps;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets value determining whether words written in all capital letters are hyphenated. Default value for this property is true.")
    public Boolean getHyphenateCaps() {
        return this.hyphenateCaps;
    }

    public void setHyphenateCaps(Boolean hyphenateCaps) {
        this.hyphenateCaps = hyphenateCaps;
    }

    public WordProcessingLoadOptions pageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
        return this;
    }

    @ApiModelProperty(required=true, value="Enable or disable generation of page numbering in converted document. Default: false")
    public Boolean getPageNumbering() {
        return this.pageNumbering;
    }

    public void setPageNumbering(Boolean pageNumbering) {
        this.pageNumbering = pageNumbering;
    }

    public WordProcessingLoadOptions preserveDocumentStructure(Boolean preserveDocumentStructure) {
        this.preserveDocumentStructure = preserveDocumentStructure;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether the document structure should be preserved when converting to PDF (default is false).")
    public Boolean getPreserveDocumentStructure() {
        return this.preserveDocumentStructure;
    }

    public void setPreserveDocumentStructure(Boolean preserveDocumentStructure) {
        this.preserveDocumentStructure = preserveDocumentStructure;
    }

    public WordProcessingLoadOptions skipExternalResources(Boolean skipExternalResources) {
        this.skipExternalResources = skipExternalResources;
        return this;
    }

    @ApiModelProperty(required=true, value="If true all external resource will not be loading. Default is true.")
    public Boolean getSkipExternalResources() {
        return this.skipExternalResources;
    }

    public void setSkipExternalResources(Boolean skipExternalResources) {
        this.skipExternalResources = skipExternalResources;
    }

    public WordProcessingLoadOptions useTextShaper(Boolean useTextShaper) {
        this.useTextShaper = useTextShaper;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether to use a text shaper for better kerning display. Default is false.")
    public Boolean getUseTextShaper() {
        return this.useTextShaper;
    }

    public void setUseTextShaper(Boolean useTextShaper) {
        this.useTextShaper = useTextShaper;
    }

    public WordProcessingLoadOptions preserveFormFields(Boolean preserveFormFields) {
        this.preserveFormFields = preserveFormFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether to preserve Microsoft Word form fields as form fields in PDF or convert them to text. Default is false.")
    public Boolean getPreserveFormFields() {
        return this.preserveFormFields;
    }

    public void setPreserveFormFields(Boolean preserveFormFields) {
        this.preserveFormFields = preserveFormFields;
    }

    public WordProcessingLoadOptions commentDisplayMode(CommentDisplayModeEnum commentDisplayMode) {
        this.commentDisplayMode = commentDisplayMode;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies how comments should be displayed in the output document. Default is Balloon.")
    public CommentDisplayModeEnum getCommentDisplayMode() {
        return this.commentDisplayMode;
    }

    public void setCommentDisplayMode(CommentDisplayModeEnum commentDisplayMode) {
        this.commentDisplayMode = commentDisplayMode;
    }

    public WordProcessingLoadOptions keepDateFieldOriginalValue(Boolean keepDateFieldOriginalValue) {
        this.keepDateFieldOriginalValue = keepDateFieldOriginalValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Keep original value of date field. Default: false")
    public Boolean getKeepDateFieldOriginalValue() {
        return this.keepDateFieldOriginalValue;
    }

    public void setKeepDateFieldOriginalValue(Boolean keepDateFieldOriginalValue) {
        this.keepDateFieldOriginalValue = keepDateFieldOriginalValue;
    }

    public WordProcessingLoadOptions updateFields(Boolean updateFields) {
        this.updateFields = updateFields;
        return this;
    }

    @ApiModelProperty(required=true, value="Update fields after loading. Default: false")
    public Boolean getUpdateFields() {
        return this.updateFields;
    }

    public void setUpdateFields(Boolean updateFields) {
        this.updateFields = updateFields;
    }

    public WordProcessingLoadOptions updatePageLayout(Boolean updatePageLayout) {
        this.updatePageLayout = updatePageLayout;
        return this;
    }

    @ApiModelProperty(required=true, value="Update page layout after loading. Default: false")
    public Boolean getUpdatePageLayout() {
        return this.updatePageLayout;
    }

    public void setUpdatePageLayout(Boolean updatePageLayout) {
        this.updatePageLayout = updatePageLayout;
    }

    public WordProcessingLoadOptions embedTrueTypeFonts(Boolean embedTrueTypeFonts) {
        this.embedTrueTypeFonts = embedTrueTypeFonts;
        return this;
    }

    @ApiModelProperty(required=true, value="If EmbedTrueTypeFonts is true, GroupDocs.Conversion Cloud embed true type fonts in the output document. Default: true")
    public Boolean getEmbedTrueTypeFonts() {
        return this.embedTrueTypeFonts;
    }

    public void setEmbedTrueTypeFonts(Boolean embedTrueTypeFonts) {
        this.embedTrueTypeFonts = embedTrueTypeFonts;
    }

    public WordProcessingLoadOptions fontInfoSubstitutionEnabled(Boolean fontInfoSubstitutionEnabled) {
        this.fontInfoSubstitutionEnabled = fontInfoSubstitutionEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Automatically substitutes missing fonts based on FontInfo in the document. Default: false.")
    public Boolean getFontInfoSubstitutionEnabled() {
        return this.fontInfoSubstitutionEnabled;
    }

    public void setFontInfoSubstitutionEnabled(Boolean fontInfoSubstitutionEnabled) {
        this.fontInfoSubstitutionEnabled = fontInfoSubstitutionEnabled;
    }

    public WordProcessingLoadOptions fontConfigSubstitutionEnabled(Boolean fontConfigSubstitutionEnabled) {
        this.fontConfigSubstitutionEnabled = fontConfigSubstitutionEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Automatically substitutes missing fonts based on FontConfig in the system. Default: false.")
    public Boolean getFontConfigSubstitutionEnabled() {
        return this.fontConfigSubstitutionEnabled;
    }

    public void setFontConfigSubstitutionEnabled(Boolean fontConfigSubstitutionEnabled) {
        this.fontConfigSubstitutionEnabled = fontConfigSubstitutionEnabled;
    }

    public WordProcessingLoadOptions fontNameSubstitutionEnabled(Boolean fontNameSubstitutionEnabled) {
        this.fontNameSubstitutionEnabled = fontNameSubstitutionEnabled;
        return this;
    }

    @ApiModelProperty(required=true, value="Automatically substitutes missing fonts based on the font name. Default: false.")
    public Boolean getFontNameSubstitutionEnabled() {
        return this.fontNameSubstitutionEnabled;
    }

    public void setFontNameSubstitutionEnabled(Boolean fontNameSubstitutionEnabled) {
        this.fontNameSubstitutionEnabled = fontNameSubstitutionEnabled;
    }

    public WordProcessingLoadOptions showFullCommenterName(Boolean showFullCommenterName) {
        this.showFullCommenterName = showFullCommenterName;
        return this;
    }

    @ApiModelProperty(required=true, value="Show full commenter name in comments. Default is false.")
    public Boolean getShowFullCommenterName() {
        return this.showFullCommenterName;
    }

    public void setShowFullCommenterName(Boolean showFullCommenterName) {
        this.showFullCommenterName = showFullCommenterName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordProcessingLoadOptions wordProcessingLoadOptions = (WordProcessingLoadOptions)o;
        return Objects.equals(this.defaultFont, wordProcessingLoadOptions.defaultFont) && Objects.equals(this.fontSubstitutes, wordProcessingLoadOptions.fontSubstitutes) && Objects.equals(this.password, wordProcessingLoadOptions.password) && Objects.equals(this.hideWordTrackedChanges, wordProcessingLoadOptions.hideWordTrackedChanges) && Objects.equals(this.bookmarksOutlineLevel, wordProcessingLoadOptions.bookmarksOutlineLevel) && Objects.equals(this.headingsOutlineLevels, wordProcessingLoadOptions.headingsOutlineLevels) && Objects.equals(this.expandedOutlineLevels, wordProcessingLoadOptions.expandedOutlineLevels) && Objects.equals(this.clearCustomDocumentProperties, wordProcessingLoadOptions.clearCustomDocumentProperties) && Objects.equals(this.clearBuiltInDocumentProperties, wordProcessingLoadOptions.clearBuiltInDocumentProperties) && Objects.equals(this.depth, wordProcessingLoadOptions.depth) && Objects.equals(this.convertOwned, wordProcessingLoadOptions.convertOwned) && Objects.equals(this.convertOwner, wordProcessingLoadOptions.convertOwner) && Objects.equals(this.autoHyphenation, wordProcessingLoadOptions.autoHyphenation) && Objects.equals(this.hyphenateCaps, wordProcessingLoadOptions.hyphenateCaps) && Objects.equals(this.pageNumbering, wordProcessingLoadOptions.pageNumbering) && Objects.equals(this.preserveDocumentStructure, wordProcessingLoadOptions.preserveDocumentStructure) && Objects.equals(this.skipExternalResources, wordProcessingLoadOptions.skipExternalResources) && Objects.equals(this.useTextShaper, wordProcessingLoadOptions.useTextShaper) && Objects.equals(this.preserveFormFields, wordProcessingLoadOptions.preserveFormFields) && Objects.equals((Object)this.commentDisplayMode, (Object)wordProcessingLoadOptions.commentDisplayMode) && Objects.equals(this.keepDateFieldOriginalValue, wordProcessingLoadOptions.keepDateFieldOriginalValue) && Objects.equals(this.updateFields, wordProcessingLoadOptions.updateFields) && Objects.equals(this.updatePageLayout, wordProcessingLoadOptions.updatePageLayout) && Objects.equals(this.embedTrueTypeFonts, wordProcessingLoadOptions.embedTrueTypeFonts) && Objects.equals(this.fontInfoSubstitutionEnabled, wordProcessingLoadOptions.fontInfoSubstitutionEnabled) && Objects.equals(this.fontConfigSubstitutionEnabled, wordProcessingLoadOptions.fontConfigSubstitutionEnabled) && Objects.equals(this.fontNameSubstitutionEnabled, wordProcessingLoadOptions.fontNameSubstitutionEnabled) && Objects.equals(this.showFullCommenterName, wordProcessingLoadOptions.showFullCommenterName) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultFont, this.fontSubstitutes, this.password, this.hideWordTrackedChanges, this.bookmarksOutlineLevel, this.headingsOutlineLevels, this.expandedOutlineLevels, this.clearCustomDocumentProperties, this.clearBuiltInDocumentProperties, this.depth, this.convertOwned, this.convertOwner, this.autoHyphenation, this.hyphenateCaps, this.pageNumbering, this.preserveDocumentStructure, this.skipExternalResources, this.useTextShaper, this.preserveFormFields, this.commentDisplayMode, this.keepDateFieldOriginalValue, this.updateFields, this.updatePageLayout, this.embedTrueTypeFonts, this.fontInfoSubstitutionEnabled, this.fontConfigSubstitutionEnabled, this.fontNameSubstitutionEnabled, this.showFullCommenterName, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WordProcessingLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    defaultFont: ").append(this.toIndentedString(this.defaultFont)).append("\n");
        sb.append("    fontSubstitutes: ").append(this.toIndentedString(this.fontSubstitutes)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    hideWordTrackedChanges: ").append(this.toIndentedString(this.hideWordTrackedChanges)).append("\n");
        sb.append("    bookmarksOutlineLevel: ").append(this.toIndentedString(this.bookmarksOutlineLevel)).append("\n");
        sb.append("    headingsOutlineLevels: ").append(this.toIndentedString(this.headingsOutlineLevels)).append("\n");
        sb.append("    expandedOutlineLevels: ").append(this.toIndentedString(this.expandedOutlineLevels)).append("\n");
        sb.append("    clearCustomDocumentProperties: ").append(this.toIndentedString(this.clearCustomDocumentProperties)).append("\n");
        sb.append("    clearBuiltInDocumentProperties: ").append(this.toIndentedString(this.clearBuiltInDocumentProperties)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    convertOwned: ").append(this.toIndentedString(this.convertOwned)).append("\n");
        sb.append("    convertOwner: ").append(this.toIndentedString(this.convertOwner)).append("\n");
        sb.append("    autoHyphenation: ").append(this.toIndentedString(this.autoHyphenation)).append("\n");
        sb.append("    hyphenateCaps: ").append(this.toIndentedString(this.hyphenateCaps)).append("\n");
        sb.append("    pageNumbering: ").append(this.toIndentedString(this.pageNumbering)).append("\n");
        sb.append("    preserveDocumentStructure: ").append(this.toIndentedString(this.preserveDocumentStructure)).append("\n");
        sb.append("    skipExternalResources: ").append(this.toIndentedString(this.skipExternalResources)).append("\n");
        sb.append("    useTextShaper: ").append(this.toIndentedString(this.useTextShaper)).append("\n");
        sb.append("    preserveFormFields: ").append(this.toIndentedString(this.preserveFormFields)).append("\n");
        sb.append("    commentDisplayMode: ").append(this.toIndentedString((Object)this.commentDisplayMode)).append("\n");
        sb.append("    keepDateFieldOriginalValue: ").append(this.toIndentedString(this.keepDateFieldOriginalValue)).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.updateFields)).append("\n");
        sb.append("    updatePageLayout: ").append(this.toIndentedString(this.updatePageLayout)).append("\n");
        sb.append("    embedTrueTypeFonts: ").append(this.toIndentedString(this.embedTrueTypeFonts)).append("\n");
        sb.append("    fontInfoSubstitutionEnabled: ").append(this.toIndentedString(this.fontInfoSubstitutionEnabled)).append("\n");
        sb.append("    fontConfigSubstitutionEnabled: ").append(this.toIndentedString(this.fontConfigSubstitutionEnabled)).append("\n");
        sb.append("    fontNameSubstitutionEnabled: ").append(this.toIndentedString(this.fontNameSubstitutionEnabled)).append("\n");
        sb.append("    showFullCommenterName: ").append(this.toIndentedString(this.showFullCommenterName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommentDisplayModeEnum {
        HIDDEN("Hidden"),
        BALLOON("Balloon"),
        ANNOTATION("Annotation");

        private String value;

        private CommentDisplayModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommentDisplayModeEnum fromValue(String text) {
            for (CommentDisplayModeEnum b : CommentDisplayModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CommentDisplayModeEnum> {
            public void write(JsonWriter jsonWriter, CommentDisplayModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommentDisplayModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommentDisplayModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

