/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.api;

import com.google.gson.reflect.TypeToken;
import com.groupdocs.cloud.editor.client.ApiCallback;
import com.groupdocs.cloud.editor.client.ApiClient;
import com.groupdocs.cloud.editor.client.ApiException;
import com.groupdocs.cloud.editor.client.ApiResponse;
import com.groupdocs.cloud.editor.client.Configuration;
import com.groupdocs.cloud.editor.client.Pair;
import com.groupdocs.cloud.editor.client.ProgressRequestBody;
import com.groupdocs.cloud.editor.client.ProgressResponseBody;
import com.groupdocs.cloud.editor.model.DocumentResult;
import com.groupdocs.cloud.editor.model.LoadOptions;
import com.groupdocs.cloud.editor.model.LoadResult;
import com.groupdocs.cloud.editor.model.SaveOptions;
import com.groupdocs.cloud.editor.model.requests.LoadRequest;
import com.groupdocs.cloud.editor.model.requests.SaveRequest;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class EditApi {
    private ApiClient apiClient;

    public EditApi(String appSid, String appKey) {
        this(new Configuration(appSid, appKey));
    }

    public EditApi(Configuration configuration) {
        this.apiClient = new ApiClient(configuration);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call loadCall(LoadRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        LoadOptions localVarPostBody = request.getloadOptions();
        String localVarPath = "/editor/load";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loadValidateBeforeCall(LoadRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getloadOptions() == null) {
            throw new ApiException("Missing the required parameter 'loadOptions' when calling load(Async)");
        }
        Call call = this.loadCall(request, progressListener, progressRequestListener);
        return call;
    }

    public LoadResult load(LoadRequest request) throws ApiException {
        ApiResponse<LoadResult> resp = this.loadWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<LoadResult> loadWithHttpInfo(LoadRequest request) throws ApiException {
        Call call = this.loadValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<LoadResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loadAsync(LoadRequest request, final ApiCallback<LoadResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loadValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LoadResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call saveCall(SaveRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SaveOptions localVarPostBody = request.getsaveOptions();
        String localVarPath = "/editor/save";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"JWT"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call saveValidateBeforeCall(SaveRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (request.getsaveOptions() == null) {
            throw new ApiException("Missing the required parameter 'saveOptions' when calling save(Async)");
        }
        Call call = this.saveCall(request, progressListener, progressRequestListener);
        return call;
    }

    public DocumentResult save(SaveRequest request) throws ApiException {
        ApiResponse<DocumentResult> resp = this.saveWithHttpInfo(request);
        return resp.getData();
    }

    public ApiResponse<DocumentResult> saveWithHttpInfo(SaveRequest request) throws ApiException {
        Call call = this.saveValidateBeforeCall(request, null, null);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call saveAsync(SaveRequest request, final ApiCallback<DocumentResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.saveValidateBeforeCall(request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DocumentResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

