/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.client.auth;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.client.ApiException;
import com.groupdocs.cloud.editor.client.Configuration;
import com.groupdocs.cloud.editor.client.JSON;
import com.groupdocs.cloud.editor.client.Pair;
import com.groupdocs.cloud.editor.client.auth.Authentication;
import com.groupdocs.cloud.editor.model.ApiError;
import com.groupdocs.cloud.editor.model.AuthError;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OAuth
implements Authentication {
    static final int MILLIS_PER_SECOND = 1000;
    private volatile String accessToken;
    private OkHttpClient httpClient;
    private JSON json;
    private String tokenUrl;
    private String appSid;
    private String appKey;

    public String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth(Configuration configuration, String appSid, String appKey) {
        this.tokenUrl = configuration.getApiBaseUrl();
        this.appSid = appSid;
        this.appKey = appKey;
        this.httpClient = new OkHttpClient();
        this.httpClient.setConnectTimeout((long)configuration.getTimeout(), TimeUnit.MILLISECONDS);
        this.httpClient.setReadTimeout((long)configuration.getTimeout(), TimeUnit.MILLISECONDS);
        this.json = new JSON();
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) throws ApiException {
        if (headerParams.containsKey("Authorization")) {
            return;
        }
        if (this.accessToken == null) {
            this.requestAccessToken();
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    private synchronized void requestAccessToken() throws ApiException {
        String url = this.tokenUrl + "/connect/token";
        Request.Builder reqBuilder = new Request.Builder().url(url);
        reqBuilder.header("Accept", "application/json");
        reqBuilder.header("Content-Type", "application/x-www-form-urlencoded");
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        formBuilder.add("grant_type", "client_credentials");
        formBuilder.add("client_id", this.appSid);
        formBuilder.add("client_secret", this.appKey);
        RequestBody reqBody = formBuilder.build();
        Request request = reqBuilder.method("POST", reqBody).build();
        Call call = this.httpClient.newCall(request);
        try {
            Response response = call.execute();
            OAuthResponse data = this.handleResponse(response);
            this.setAccessToken(data.getAccessToken());
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private OAuthResponse handleResponse(Response response) throws ApiException {
        if (response.isSuccessful()) {
            if (response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), response.code());
                    }
                }
                return null;
            }
            return this.deserialize(response);
        }
        if (response.body() != null) {
            String respBody;
            try {
                respBody = response.body().string();
            }
            catch (Exception e) {
                throw new ApiException(response.message(), response.code());
            }
            ApiError apiError = null;
            try {
                apiError = (ApiError)this.json.deserialize(respBody, (Type)((Object)ApiError.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (apiError != null && apiError.getError() != null) {
                throw new ApiException(apiError.getError().getMessage(), response.code());
            }
            AuthError authError = null;
            try {
                authError = (AuthError)this.json.deserialize(respBody, (Type)((Object)AuthError.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (authError != null && authError.getErrorMessage() != null) {
                throw new ApiException(authError.getErrorMessage(), response.code());
            }
        }
        throw new ApiException(response.message(), response.code());
    }

    private OAuthResponse deserialize(Response response) throws ApiException {
        String respBody;
        if (response == null) {
            return null;
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        return (OAuthResponse)this.json.deserialize(respBody, (Type)((Object)OAuthResponse.class));
    }

    private class OAuthResponse {
        @SerializedName(value="access_token")
        private String accessToken = null;
        @SerializedName(value="token_type")
        private String tokenType = null;
        @SerializedName(value="expires_in")
        private Long expiresIn = null;

        private OAuthResponse() {
        }

        public OAuthResponse accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @ApiModelProperty(value="")
        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public OAuthResponse tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @ApiModelProperty(value="")
        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public OAuthResponse expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @ApiModelProperty(value="")
        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }
    }
}

