/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.model.LoadOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Options for loading text-based Spreadsheet documents (CSV, Tab-based etc.), that use a separator (delimiter)")
public class DelimitedTextLoadOptions
extends LoadOptions {
    @SerializedName(value="separator")
    private String separator = null;
    @SerializedName(value="convertDateTimeData")
    private Boolean convertDateTimeData = null;
    @SerializedName(value="convertNumericData")
    private Boolean convertNumericData = null;
    @SerializedName(value="treatConsecutiveDelimitersAsOne")
    private Boolean treatConsecutiveDelimitersAsOne = null;

    public DelimitedTextLoadOptions separator(String separator) {
        this.separator = separator;
        return this;
    }

    @ApiModelProperty(value="Allows to specify a string separator (delimiter) for text-based Spreadsheet documents             ")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public DelimitedTextLoadOptions convertDateTimeData(Boolean convertDateTimeData) {
        this.convertDateTimeData = convertDateTimeData;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value that indicates whether the string in text-based document is converted to the date data. Default is false.")
    public Boolean getConvertDateTimeData() {
        return this.convertDateTimeData;
    }

    public void setConvertDateTimeData(Boolean convertDateTimeData) {
        this.convertDateTimeData = convertDateTimeData;
    }

    public DelimitedTextLoadOptions convertNumericData(Boolean convertNumericData) {
        this.convertNumericData = convertNumericData;
        return this;
    }

    @ApiModelProperty(required=true, value="Gets or sets a value that indicates whether the string in text-based document is converted to numeric data. Default is false.")
    public Boolean getConvertNumericData() {
        return this.convertNumericData;
    }

    public void setConvertNumericData(Boolean convertNumericData) {
        this.convertNumericData = convertNumericData;
    }

    public DelimitedTextLoadOptions treatConsecutiveDelimitersAsOne(Boolean treatConsecutiveDelimitersAsOne) {
        this.treatConsecutiveDelimitersAsOne = treatConsecutiveDelimitersAsOne;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines whether consecutive delimiters should be treated as one. By default is false.")
    public Boolean getTreatConsecutiveDelimitersAsOne() {
        return this.treatConsecutiveDelimitersAsOne;
    }

    public void setTreatConsecutiveDelimitersAsOne(Boolean treatConsecutiveDelimitersAsOne) {
        this.treatConsecutiveDelimitersAsOne = treatConsecutiveDelimitersAsOne;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimitedTextLoadOptions delimitedTextLoadOptions = (DelimitedTextLoadOptions)o;
        return Objects.equals(this.separator, delimitedTextLoadOptions.separator) && Objects.equals(this.convertDateTimeData, delimitedTextLoadOptions.convertDateTimeData) && Objects.equals(this.convertNumericData, delimitedTextLoadOptions.convertNumericData) && Objects.equals(this.treatConsecutiveDelimitersAsOne, delimitedTextLoadOptions.treatConsecutiveDelimitersAsOne) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.separator, this.convertDateTimeData, this.convertNumericData, this.treatConsecutiveDelimitersAsOne, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DelimitedTextLoadOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("    convertDateTimeData: ").append(this.toIndentedString(this.convertDateTimeData)).append("\n");
        sb.append("    convertNumericData: ").append(this.toIndentedString(this.convertNumericData)).append("\n");
        sb.append("    treatConsecutiveDelimitersAsOne: ").append(this.toIndentedString(this.treatConsecutiveDelimitersAsOne)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

