/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.annotations.SerializedName;
import com.groupdocs.cloud.editor.model.SaveOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains options for generating and saving text-based Spreadsheet documents (CSV, Tab-based etc.), that use a separator (delimiter)")
public class DelimitedTextSaveOptions
extends SaveOptions {
    @SerializedName(value="separator")
    private String separator = null;
    @SerializedName(value="encoding")
    private String encoding = null;
    @SerializedName(value="trimLeadingBlankRowAndColumn")
    private Boolean trimLeadingBlankRowAndColumn = null;
    @SerializedName(value="keepSeparatorsForBlankRow")
    private Boolean keepSeparatorsForBlankRow = null;

    public DelimitedTextSaveOptions separator(String separator) {
        this.separator = separator;
        return this;
    }

    @ApiModelProperty(value="Allows to specify a string separator (delimiter) for text-based Spreadsheet documents")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public DelimitedTextSaveOptions encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Allows to set an encoding for the text-based Spreadsheet document. By default (and if not specified) is UTF-8.")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public DelimitedTextSaveOptions trimLeadingBlankRowAndColumn(Boolean trimLeadingBlankRowAndColumn) {
        this.trimLeadingBlankRowAndColumn = trimLeadingBlankRowAndColumn;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether leading blank rows and columns should be trimmed like what MS Excel does")
    public Boolean getTrimLeadingBlankRowAndColumn() {
        return this.trimLeadingBlankRowAndColumn;
    }

    public void setTrimLeadingBlankRowAndColumn(Boolean trimLeadingBlankRowAndColumn) {
        this.trimLeadingBlankRowAndColumn = trimLeadingBlankRowAndColumn;
    }

    public DelimitedTextSaveOptions keepSeparatorsForBlankRow(Boolean keepSeparatorsForBlankRow) {
        this.keepSeparatorsForBlankRow = keepSeparatorsForBlankRow;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether separators should be output for blank row. Default value is false which means the content for blank row will be empty.")
    public Boolean getKeepSeparatorsForBlankRow() {
        return this.keepSeparatorsForBlankRow;
    }

    public void setKeepSeparatorsForBlankRow(Boolean keepSeparatorsForBlankRow) {
        this.keepSeparatorsForBlankRow = keepSeparatorsForBlankRow;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimitedTextSaveOptions delimitedTextSaveOptions = (DelimitedTextSaveOptions)o;
        return Objects.equals(this.separator, delimitedTextSaveOptions.separator) && Objects.equals(this.encoding, delimitedTextSaveOptions.encoding) && Objects.equals(this.trimLeadingBlankRowAndColumn, delimitedTextSaveOptions.trimLeadingBlankRowAndColumn) && Objects.equals(this.keepSeparatorsForBlankRow, delimitedTextSaveOptions.keepSeparatorsForBlankRow) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.separator, this.encoding, this.trimLeadingBlankRowAndColumn, this.keepSeparatorsForBlankRow, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DelimitedTextSaveOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    separator: ").append(this.toIndentedString(this.separator)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    trimLeadingBlankRowAndColumn: ").append(this.toIndentedString(this.trimLeadingBlankRowAndColumn)).append("\n");
        sb.append("    keepSeparatorsForBlankRow: ").append(this.toIndentedString(this.keepSeparatorsForBlankRow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

