/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.cloud.editor.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.groupdocs.cloud.editor.model.SaveOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Allows to specify custom options for generating and saving PDF (Portable Document Format) documents")
public class PdfSaveOptions
extends SaveOptions {
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="compliance")
    private ComplianceEnum compliance = null;

    public PdfSaveOptions password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Password, which will be applied to the generated PDF document as user password, required for opening. If NULL or empty, no password will be applied to the document. Otherwise, document will be encrypted with RC4 (key length of 128 bit).             ")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PdfSaveOptions compliance(ComplianceEnum compliance) {
        this.compliance = compliance;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the PDF standards compliance level for output documents. Default is PdfCompliance.Pdf15.             ")
    public ComplianceEnum getCompliance() {
        return this.compliance;
    }

    public void setCompliance(ComplianceEnum compliance) {
        this.compliance = compliance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfSaveOptions pdfSaveOptions = (PdfSaveOptions)o;
        return Objects.equals(this.password, pdfSaveOptions.password) && Objects.equals((Object)this.compliance, (Object)pdfSaveOptions.compliance) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.password, this.compliance, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfSaveOptions {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    compliance: ").append(this.toIndentedString((Object)this.compliance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ComplianceEnum {
        PDF15("Pdf15"),
        PDFA1A("PdfA1a"),
        PDFA1B("PdfA1b");

        private String value;

        private ComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ComplianceEnum fromValue(String text) {
            for (ComplianceEnum b : ComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ComplianceEnum> {
            public void write(JsonWriter jsonWriter, ComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

